//
//  ProtocolCell.swift
//  ctband
//
//  Created by Mac on 2020/4/27.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
import SnapKit
import TableViewManager;

final class ProtocolCell: BaseTableViewCell, ZJCellProtocol {

    // MARK: - ZJCellProtocol
    var item: ProtocolItem!
    typealias ZJCelltemClass = ProtocolItem
    override func cellWillAppear() {
        nameLab.text = item.text
        dataLab.text = item.detail
        if item.detail.count > 0 {
            dataLab.snp.updateConstraints { (make) in
                make.top.equalTo(nameLab.snp.bottom).offset(Constraints.small)
            }
        } else {
            dataLab.snp.updateConstraints { (make) in
                make.top.equalTo(nameLab.snp.bottom)
            }
        }
        
    }
    
    // MARK: - Initialize
    
    override func prepareForReuse() {
        super.prepareForReuse()
        nameLab.text = nil
        dataLab.text = nil
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setConstraints()

    }

    // MARK: - View customer

    private func setConstraints() {
        [nameLab, dataLab].forEach { view in
            view.textAlignment = .left
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        nameLab.snp.makeConstraints { (make) in
            make.top.equalToSuperview().offset(Constraints.normal)
            make.leading.equalTo(self.snp.leadingMargin)
            make.height.equalTo(20)
        }
        dataLab.snp.makeConstraints { (make) in
            make.leading.equalTo(self.snp.leadingMargin)
            make.right.equalTo(self.snp.rightMargin).offset(-Constraints.small)
            make.bottom.equalToSuperview().offset(-Constraints.normal)
            make.top.equalTo(nameLab.snp.bottom).offset(Constraints.small)

        }
    }
    
    private let nameLab = UILabel(style: Stylesheet.Label.title)

    private let dataLab = UILabel(style: Stylesheet.Label.description)

}
