//
//  SearchedDatasource.swift
//  CTFit
//
//  Created by Mac on 2020/7/18.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import RxSwift

enum SearchActionType {
    typealias FoundType = (item: SearchedItem, index: Int, first: Bool)
    case found(FoundType), end(BDSearchAction.EndType)
}

final class SearchedDatasource {

    init() {
        observe()
    }

    deinit {
        if !BandConnect.isConnected { BandConnect.reconnect() }
    }
    
    func searchStart() { isFirstResult = true; BandSearch.searchStart(3) }
    func searchStop() { BandSearch.searchStop() }
    func connect(for band: BandPeripheral) { BandConnect.connect(for: band) }
    func disconnect() { BandConnect.disconnect() }
    
    func observe() {
        BandSearch.searchActionOutput.subscribe(onNext: {[weak self] action in
            guard let strong = self else { return }
            strong.update(search: action)
        }).disposed(by: disposeBag)
    }
    
    
    private func update(search action: BDSearchAction) {
        
        if case BDSearchAction.found(let peripheral) = action {
            
            guard peripheral.support else { return }
            if isFirstResult { peripherals.removeAll() }
            
            if peripherals.contains(where: { $0 == peripheral }) { return }
            peripherals.append(peripheral)
            peripherals = peripherals.sorted { (a, b) -> Bool in return a > b; }
            guard let idx = peripherals.firstIndex(of: peripheral) else { return} ;

            let item = SearchedItem(searched: peripheral)
            self.searchActionOutput.onNext(.found((item, idx, isFirstResult)))
            isFirstResult = false
        }
        
        if case BDSearchAction.end(let type) = action {
            self.searchActionOutput.onNext(.end(type))
        }
    }
    

    // MARK: - Field
    private var isFirstResult = true;
    private var peripherals = [BandPeripheral]()

    // Rx
    private let disposeBag = DisposeBag()
    
    // Ountput
    let searchActionOutput = PublishSubject<SearchActionType>()
    let connectActionOutput : Observable<BDConnectAction> = { BandConnect.actionChangedOutput } ()
}


