import UIKit
import SnapKit
import TableViewManager;

final class SearchedCell: BaseTableViewCell, ZJCellProtocol {

    ///: - ZJCellProtocol
    var item: SearchedItem!
    typealias ZJCelltemClass = SearchedItem
    override func cellWillAppear() {
        peripheralNameLabel.text = item.text
        rssiLabel.text = item.detail
    }
    
    
    ///: - Initialize
    override func prepareForReuse() {
        super.prepareForReuse()
        peripheralNameLabel.text = nil
        rssiLabel.text = nil
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: .default, reuseIdentifier: reuseIdentifier)
        setConstraints()
    }
    
   
    // MARK: - View customer
    private func setConstraints() {
        [peripheralNameLabel, rssiLabel].forEach { view in
            view.translatesAutoresizingMaskIntoConstraints = false
            addSubview(view)
        }
        peripheralNameLabel.snp.makeConstraints { (make) in
            make.leading.equalTo(self.snp.leadingMargin)
            make.top.equalToSuperview().offset(Constraints.small)
        }
        rssiLabel.snp.makeConstraints { (make) in
            make.leading.equalTo(peripheralNameLabel.snp.leading)
            make.top.equalTo(peripheralNameLabel.snp.bottom).offset(Constraints.small/2)
            make.bottom.equalToSuperview().offset(-Constraints.small)
        }
    }
        
    private let peripheralNameLabel = UILabel(style: Stylesheet.Label.title)
    private let rssiLabel = UILabel(style: Stylesheet.Label.description)
}
