import UIKit
import TableViewManager;

final class SearchedItem: BaseTableViewItem {
    
    
    ///: - Cell source
    var text: String { peripheral.peripheralName }
    var detail: String { peripheral.rssiText }
    
    ///: - Initialize
    private override init() {
        super.init()
        selectionStyle = .default
        accessoryView = .none
    }
    convenience init(searched peripheral: BandPeripheral) {
        self.init()
        self.peripheral = peripheral
    }
    
    ///: - Field
    var peripheral: BandPeripheral!
}

extension BaseTableViewSection {
    func insert(searched item: SearchedItem, at i: Int) {
        item.section = self
        item.tableViewManager = self.tableViewManager
        items.insert(item, at: i)
    }
}

