//
//  ProgressView.swift
//  CTFit
//
//  Created by Mac on 2020/8/7.
//  Copyright © 2020 shirajo. All rights reserved.
//

import UIKit
class ProgressView: UIControl {
    
    //进度值
    var progress : CGFloat = 0.0 {
        didSet{
            let anima = CATransition()
            anima.duration = 0.15
            valueLabel.text = String(format: "%.0f%%", progress * 100)
            valueLabel.layer.add(anima, forKey: nil)
            
            CATransaction.begin()
            CATransaction.setValue(kCFBooleanTrue, forKey: kCATransactionDisableActions)
            progressLayer.strokeEnd = progress
            CATransaction.commit()
        }
    }
    
    var statusText : String? {
        didSet { describeLabel.text = statusText }
    }

    
    
    // MARK: - Initialize

    @available(*, unavailable)
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initlized()
    }
    
    
    
    private func initlized(){
        /// 添加数值Label
        addSubview(valueLabel)
        
        addSubview(describeLabel)
        
        /// 底层
        layer.addSublayer(bottomLayer)
        
        /// 覆盖层
        layer.addSublayer(progressLayer)
    }
    
    // MARK: - Private field

    private let duration: TimeInterval = 2.0

    private let lineWidth: CGFloat = 2

    private let normalColor = Colors.Base.description
    
    private let strokeColor = Colors.white
    
    private let startAngle: CGFloat = 270
    
    private let allAngle: CGFloat = 360
    
    private var _width: CGFloat { min(self.bounds.size.width, self.bounds.size.height) }
    
    private var _center: CGPoint { CGPoint(x: self.bounds.size.width/2, y: self.bounds.size.height/2) }
    
    private var displayLink: CADisplayLink?


    // 数值label
    private lazy var valueLabel: UILabel = {
        let label = UILabel(frame: CGRect(x: 0, y: 0, width: 150, height: 50))
        Stylesheet.Label.text.apply(to: label)
        label.font = .lightCustomFont(ofSize: 36)
        label.center = CGPoint(x: _center.x, y: _center.y - 25)
        label.textColor = strokeColor
        label.text = "0%"
        label.textAlignment = .center
        return label
    }()
    
    // 描述label
    private lazy var describeLabel: UILabel = {
        let label = UILabel(frame: CGRect(x: 0, y: 0, width: 150, height: 50))
        Stylesheet.Label.text.apply(to: label)
        label.center = CGPoint(x: _center.x, y: _center.y + 25)
        label.text = SRString.Upgrade.loading.locastr
        label.textAlignment = .center
        return label
    }()
    
    //遮盖layer
    private lazy var progressLayer: CAShapeLayer = {
        let radius = (_width - lineWidth)/2
        let bezierPath = UIBezierPath(arcCenter: _center, radius: radius, startAngle: radian(from: startAngle) , endAngle: radian(from: startAngle+allAngle), clockwise: true)
        let shapeLayer = CAShapeLayer()
        shapeLayer.lineWidth = lineWidth
        shapeLayer.fillColor = UIColor.clear.cgColor
        shapeLayer.strokeColor = strokeColor.cgColor
        shapeLayer.path = bezierPath.cgPath
        shapeLayer.strokeStart = 0.0
        shapeLayer.strokeEnd = 0.0
        return shapeLayer
    }()
    
    private lazy var bottomLayer: CAShapeLayer = {
        let radius = (_width - lineWidth)/2
        let bezierPath = UIBezierPath(arcCenter: _center, radius: radius, startAngle: radian(from: startAngle) , endAngle: radian(from: startAngle+allAngle), clockwise: true)
        let shapeLayer = CAShapeLayer()
        shapeLayer.lineWidth = lineWidth
        shapeLayer.fillColor = UIColor.clear.cgColor
        shapeLayer.strokeColor = normalColor.cgColor
        shapeLayer.path = bezierPath.cgPath
        shapeLayer.strokeEnd = 1

        return shapeLayer
    }()
}

// MARK: - method

extension ProgressView {
    
    override func touchesEnded(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesEnded(touches, with: event);
        guard let touch = touches.first else { return }
        let location = touch.location(in: self)
        if self.bounds.contains(location) {
            sendActions(for: .touchUpInside);
        }
    }
    
    /// 角度 转 弧长
    private func radian(from angle: CGFloat) -> CGFloat {
        return (angle * CGFloat.pi/180.0)
    }
    
}
