
BandKit 蓝牙手环库，使与BLE设备的交互更加愉快。它由RxSwift和CoreBluetooth支持，并为中心和外围模式提供了很好的API。所有这些都可以使您的代码更具可读性、可靠性和更容易维护. 

BandKit 在这里做了什么:

```swift
manager.scanForPeripherals(withServices: [serviceId])
    .take(1)
    .flatMap { $0.peripheral.establishConnection() }
    .flatMap { $0.discoverServices([serviceId]) }
    .flatMap { Observable.from($0) }
    .flatMap { $0.discoverCharacteristics([characteristicId]) }
    .flatMap { Observable.from($0) }
    .flatMap { $0.readValue() }
    .subscribe(onNext: { print("Value: \($0.value)") })
```

仅用9行完成：扫描->外围设备连接->查找服务->查找特征->读取特征值

# Requirements

- iOS 8.0+
- OSX 10.10+
- watchOS 4.0+
- tvOS 11.0+
- Xcode 7.3+

## Swift versions

*  supports Swift 5.0
