import Foundation
import RxBluetoothKit
import CoreBluetooth

extension Characteristic {
    
    /// 检测 Characteristic 属性的写操作类型.
    /// 放回 CBCharacteristicWriteType?：(.withResponse、writeWithoutResponse、nil ) .
    func determineWriteType() -> CBCharacteristicWriteType? {
        let writeType = self.properties.contains(.write) ? CBCharacteristicWriteType.withResponse :
                self.properties.contains(.writeWithoutResponse) ? CBCharacteristicWriteType.withoutResponse : nil

        return writeType
    }
}
