//
//  SRAlarmClock.swift
//  BandKit
//
//  Created by Mac on 2020/5/7.
//

import Foundation

public class SRAlarmClock: SRModelBase, SRModelProtocol {
    /// 闹钟项 最多四组
    public var clockArray: [SRClockItem] = [SRClockItem]()
    /// 日程项 最多四组
    public var scheduleArray: [SRScheduleItem] =  [SRScheduleItem]()
    
    ///: - Initialize
    required public init() { }

    
    ///: - override

    override var dataLen: Int { 240 }

    override func data() -> Data {
        let clockLen = 80
        var data = Data()
        let clockItems = clockArray.suffix(4)
        let schedulesitems = scheduleArray.suffix(4)
        clockItems.forEach { data += $0.data() }
        if  data.count < clockLen   { data += Data(count: clockLen-data.count) }
        schedulesitems.forEach { data += $0.data() }
        if  data.count < dataLen   { data += Data(count: dataLen-data.count) }
        return data
    }
        
    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false }
        let buffer = SRByteBuffer(with: data)
        clockArray.removeAll()
        scheduleArray.removeAll()
        for _ in 0...3 {
            let item = SRClockItem()
            item.parse(buffer.getData(item.dataLen))
            if !item.invalid { clockArray.append(item) }
            
        }
        for _ in 0...3 {
            let item = SRScheduleItem()
            item.parse(buffer.getData(item.dataLen))
            if !item.invalid { scheduleArray.append(item) }
        }
        
        SRAlarmClock.readed = true
        return true
    }
}

// MARK: - 数据缓存
extension SRAlarmClock {
    func saveToCache() {
        SRAlarmClock.default = self
    }
    
    static func readForCache() -> SRAlarmClock {
        if let cache = SRAlarmClock.default { return cache }
        return SRAlarmClock()
    }
    
    private static let key = "SRAlarmClockBandKitKey"
    private static var _default: SRAlarmClock?
    private static var `default`: SRAlarmClock? {
        get {
            if let info = _default { return info}
            guard let jsonString = UserDefaults.standard.string(forKey: key) else { return nil }
            guard let info = SRAlarmClock.deserialize(from: jsonString) else { return nil }
            _default = info
            return _default
        }
        set {
            _default = newValue
            if _default != nil {
                UserDefaults.standard.set(_default!.jsonString, forKey: key)
            } else {
                UserDefaults.standard.removeObject(forKey: key)
            }
            UserDefaults.standard.synchronize()
        }
    }
}

/// 新连接设备是否读取过数据
extension SRAlarmClock {
    private static let readedKey = "SRAlarmClockReadedKey"
    public static var readed: Bool {
        get {
            UserDefaults.standard.bool(forKey: readedKey)
        }
        set {
            UserDefaults.standard.set(newValue, forKey: readedKey)
            UserDefaults.standard.synchronize()
        }
    }
}
