//
//  SRVibrate.swift
//  BandKit
//
//  Created by Mac on 2020/5/7.
//

import Foundation

public enum SRVibrateType: Int, SREnumtProtocol {
    case none
    case staccato
    case wave
    case heartbeat
    case radiate
    case lighthouse
    case symphony
    case quick
    
    public static let collection: [SRVibrateType] = [.none, .staccato, .wave, .heartbeat, .radiate, .lighthouse, .symphony, .quick]

    var value: UInt8 {
        switch self {
        case .none: return 0x00
        case .staccato: return 0x01
        case .wave: return 0x02
        case .heartbeat: return 0x03
        case .radiate: return 0x04
        case .lighthouse: return 0x05
        case .symphony: return 0x06
        case .quick: return 0x07
        }
    }
    
    var name: String {
        switch self {
        case .none: return "无铃声"
        case .staccato: return "断奏"
        case .wave: return "波浪"
        case .heartbeat: return "心跳"
        case .radiate: return "放射"
        case .lighthouse: return "灯塔"
        case .symphony: return "交响乐"
        case .quick: return "快速"
        }
    }

    static func parse(_ value: UInt8) -> SRVibrateType {
        var type: SRVibrateType = .none
        for e in collection { if e.value==value { type = e; break } }
        return type
    }
}


public class SRVibrate: SRModelBase, SRModelProtocol {
    /// 震动类型： 8 种
    public var type: SRVibrateType = .staccato
    /// 重复次数：( 0 ~ 31 )
    public var count: UInt8 = 25
    
    ///: - Initialize
    public required init() { }
    public init(type: SRVibrateType = .staccato, count: UInt8 = 25) {
        self.type = type
        self.count = count
    }
    
    ///: - internal

    var byte: UInt8 {
        get {
            let _count: UInt8 = min(count, 31)
            let _byte =  _count | (type.value << 5)
            return _byte
        }
        set {
            let byte = newValue
            type = SRVibrateType.parse(byte >> 5)
            count = byte & 0x1F
        }
    }
    
    ///: - override
    
    override var dataLen: Int { 1 }

    override func data() -> Data {
        return Data([byte])
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        byte = buffer.get()
        
        return true
    }
}
