//
//  SRDetectInfo.swift
//  BandKit
//
//  Created by Mac on 2020/5/11.
//

import Foundation

/// 最近的检测数据记录
class SRDetectInfo: SRModelBase, SRModelProtocol {
    /// 心率项，最多七组
    public private(set)  var heartRateItems = [SRDetectItem]()
    /// 血压项，最多七组
    public private(set)  var bloodPressureItems = [SRDetectItem]()    
    
    ///: - Initialize
    required public init() {}
    
    ///: - override
    
    override var dataLen: Int { 112 }

    override func data() -> Data {
        var _data = Data()
        heartRateItems.suffix(7).forEach { (item) in _data.append(item.data()) }
        bloodPressureItems.suffix(7).forEach { (item) in _data.append(item.data()) }
        return _data
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        heartRateItems.removeAll()
        bloodPressureItems.removeAll()
        for _ in 0...6 {
            let item = SRDetectItem(with: .bpm)
            item.parse(buffer.getData(item.dataLen))
            if item.valid { heartRateItems.append(item) }
        }
        for _ in 0...6 {
            let item = SRDetectItem(with: .bp)
            item.parse(buffer.getData(item.dataLen))
            if item.valid { bloodPressureItems.append(item) }
        }
        return true
    }
}


