//
//  SRFirmwareControl.swift
//  BandKit
//
//  Created by Mac on 2021/10/27.
//

import Foundation

/// 任何时候32bit里面只能有一个bit为1，否则认为无效指令；
public enum SRFirmwareControlType {
    case upgrade
    case unbind
    case poweroff
    case font
    case vibrate(SRVibrate)

    var data: Data {
        switch self {
        case .upgrade:          return Data([1, 0, 0, 0,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,])
        case .unbind:           return Data([0, 0, 0, 1,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,])
        case .poweroff:         return Data([0, 0, 0, 0,
                                             1, 0, 0, 0,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,])

        case .font:             return Data([0, 0, 1, 0,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,])
        case .vibrate(let t):   return Data([0, 0, 0, 0,
                                             0, 0, t.byte, 0,
                                             0, 0, 0, 0,
                                             0, 0, 0, 0,])
        }
    }
    
    public var name: String {
        switch self {
        case .upgrade:  return "升级模式"
        case .unbind:   return "解除绑定"
        case .poweroff: return "断电关机"
        case .font:     return "字库测试"
        case .vibrate(let t): return "铃声测试.\(t)"
        }
    }
    
    public static let collection: [SRFirmwareControlType] = [.upgrade, .unbind, .poweroff, .font, .vibrate(SRVibrate())]
}
