//
//  SRFirewareFeature.swift
//  BandKit
//
//  Created by Mac on 2020/5/9.
//

import Foundation

enum SRFirmwareFeartureType: Int, SREnumtProtocol {
    case rest_find
    case weather
    case camera
    case waterRemind
    case tempUnit
    case dateformat_detect_brightScrren
    
    var mask: UInt8 {
        switch self {
        case .rest_find:    return 0x01
        case .weather:      return 0x02
        case .camera:       return 0x04
        case .waterRemind:  return 0x08
        case .tempUnit:     return 0x10
        case .dateformat_detect_brightScrren: return 0x20
        }
    }
}

extension SRFirmwareFeartureType: CustomStringConvertible {
    var description: String {
        switch self {
        case .rest_find: return "rest_find"
        case .weather: return "weather"
        case .camera: return "camera"
        case .waterRemind: return "waterRemind"
        case .tempUnit: return "tempUnit"
        case .dateformat_detect_brightScrren: return "dateformat_detect_brightScrren"
        }
    }
}


public class SRFirmwareFeature: SRModelProtocol {
    
    /// 恢复出厂设置和查找手环
    public var rest_find: Bool { return (feature & SRFirmwareFeartureType.rest_find.mask) == SRFirmwareFeartureType.rest_find.mask }
    ///  天气推送
    public var weather: Bool { return (feature & SRFirmwareFeartureType.weather.mask) == SRFirmwareFeartureType.weather.mask }
    ///  拍照
    public var camera: Bool { return (feature & SRFirmwareFeartureType.camera.mask) == SRFirmwareFeartureType.camera.mask }
    ///  喝水提醒
    public var waterRemind: Bool { return (feature & SRFirmwareFeartureType.waterRemind.mask) == SRFirmwareFeartureType.waterRemind.mask }
    ///  温度单位切换
    public var tempUnit: Bool { return (feature & SRFirmwareFeartureType.tempUnit.mask) == SRFirmwareFeartureType.tempUnit.mask }
    ///  日期显示格式、血压、亮屏设置
    public var dateformat_detect_brightScrren: Bool { return (feature & SRFirmwareFeartureType.dateformat_detect_brightScrren.mask) == SRFirmwareFeartureType.dateformat_detect_brightScrren.mask }

    // MARK: - Initialize
    required public init() {}

    
    // MARK: - internal
    /// 功能号
    var feature: UInt8 = 0x00
    
    var list: [SRFirmwareFeartureType] {
        let all: [SRFirmwareFeartureType] = [.rest_find, .weather, .camera, .waterRemind, .tempUnit, .dateformat_detect_brightScrren]
        var result = [SRFirmwareFeartureType]()
        all.forEach { (e) in if feature&e.mask == e.mask { result.append(e)} }
        return result
    }
}

extension SRFirmwareFeature: CustomStringConvertible {
    public var description: String { "[\(list.map { String(describing: $0) }.joined(separator: ","))]" }
}

