//
//  SRFlashDateItem.swift
//  BandKit
//
//  Created by NEIL on 2020/5/10.
//

import Foundation

public class SRFlashDateItem: SRModelBase, SRModelProtocol {
    /// 年 (  > 2010 )
    public private(set) var year: UInt16 = 2010
    /// 月 ( 1~ 31 )
    public private(set) var month: UInt8 = 1
    /// 日 ( 1~ 31 )
    public private(set) var day: UInt8 = 1
    
    public var dateStr: String { String(format: "%04d-%02d-%02d", year, month, day) }
    
    var date: Date {
        SRCalendarUtils.date(withYear: Int(year), month: Int(month), day: Int(day))
    }

    ///: - Initialize
    required public init() {
        let components = SRCalendarUtils.components(ofDate: Date())
        year = UInt16(components.year!)
        month = UInt8(components.month!)
        day = UInt8(components.day!)
    }
    
    init(dateStr: String) {
        let array: Array = dateStr.components(separatedBy: "-")
        if let y = UInt16(array[0]), let m = UInt8(array[1]), let d = UInt8(array[2]) {
            year = y
            month = m
            day = d
        }
    }
    
    init(date: Date) {
        let components = SRCalendarUtils.components(ofDate: date)
        year = UInt16(components.year!)
        month = UInt8(components.month!)
        day = UInt8(components.day!)
    }
    
    ///: - internal

    func parse(dateStr: String) {
        let array: Array = dateStr.components(separatedBy: "-")
        if let y = UInt16(array[0]), let m = UInt8(array[1]), let d = UInt8(array[2]) {
            year = y
            month = m
            day = d
        }
    }

    ///: - override
    
    override var dataLen: Int { 4 }

    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putShort(year)
        buffer.putByte(month)
        buffer.putByte(day)
        return buffer.bufferData
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        year  = buffer.getShort()
        month = buffer.get()
        day   = buffer.get()
        return true
    }
    
  
    
}

extension SRFlashDateItem: CustomStringConvertible {
    public var description: String { dateStr }
}

public extension Array where Element: SRFlashDateItem{
    var kitString: String {
        return "[\(map { $0.description }.joined(separator: ", "))]"
    }
}



