//
//  SRFlashDates.swift
//  BandKit
//
//  Created by NEIL on 2020/5/10.
//

import Foundation

/// 缓存数据的日期列表( 年/月/日)
/// 最多 7 天， 可以不连续
public class SRFlashDates: SRModelBase, SRModelProtocol {
    /// 列表
    public private(set) var list = [SRFlashDateItem]()
    
    ///: - Initialize
    required public init() { }
    
   
    ///: - internal
    var locations: [UInt8] = [UInt8]()
    var count: UInt8 = 0
    var maxCount: Int { 7 }

    ///: - override
    
    override var dataLen: Int { 36 }

    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putByte(count)
        buffer.putBytes(locations)
        list.prefix(maxCount).forEach { buffer.putData($0.data()) }
        var data = buffer.bufferData
        if data.count < dataLen { data += Data(count: dataLen-data.count) }
        return data
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        count = min(buffer.get(), UInt8(maxCount))
        locations = [UInt8](buffer.getBytes(7))
        
        list.removeAll()
        for _ in 0..<count {
            let dateData = buffer.getBytes(4)
            let item = SRFlashDateItem()
            item.parse(dateData)
            list.append(item)
        }
        return true
    }
}

extension SRFlashDates: CustomStringConvertible {
    public var description: String {
        """
        \(list)
        """
    }
}



