//
//  SRStepItem.swift
//  BandKit
//
//  Created by Mac on 2020/5/13.
//

import Foundation

/// 计步类型
enum StepType: Int, SREnumtProtocol {
    case slowly // 慢走
    case walk   // 走路
    case jog    // 快走/慢跑
    case run    // 跑步
    
    static func parse(_ value: Int) -> StepType {
        if value <= 60 {
            return .slowly;
        } else if value > 60, value <= 90 {
            return .walk;
        } else if value > 90, value <= 130 {
            return .jog;
        } else {
            return .run;
        }
    }
}

/// 连续有步数的分段记录
class SRStepItem: SRModelProtocol {
    /// 计步类型
    public private(set) var type: StepType = .walk
    /// 步数
    public private(set) var steps: Int = 0
    /// 持续分钟
    public private(set) var durationMinutes: Int  = 0
    /// 开始小时 （0~23）
    public private(set) var startHour: Int  = 0
    /// 开始分钟 （0~59）
    public private(set) var startMinute: Int  = 0
    /// 结束小时 （0~23）
    public private(set) var endHour: Int  = 0
    /// 结束分钟 （0~59）
    public private(set) var endMinute: Int  = 0
    
    /// Period of time
    public var periodTime: String {
        String(format: "%02d:%02d~%02d:%02d", min(startHour, 23), min(startMinute, 59), min(endHour, 23), min(endMinute, 59))
    }
    
    ///: - Initialize
    required public init() {}
    
    ///: - internal
    
    static func instance(_ steps: Int, _ range: NSRange) -> SRStepItem? {
        guard range.length > 0, steps > 0  else { return nil}
        
        let aver = steps/range.length
        guard aver >= 60 else { return nil }
        
        let start = range.location
        let end = range.location + range.length
        
        let item = SRStepItem()
        item.type = StepType.parse(aver)
        item.steps = steps
        item.durationMinutes = range.length
        item.startHour = start / 60
        item.startMinute = start % 60
        item.endHour = end / 60
        item.endMinute = end % 60
        
        return item
    }
}


