//
//  SRModelProtocol.swift
//  CTFit
//
//  Created by Mac on 2020/8/20.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import HandyJSON
import NEUtils

///: - EnumtProtocol
typealias SREnumtProtocol = NEEnumtProtocol

///: - ModelProtocol
typealias SRModelProtocol = NEModelProtocol

///: - ModelBase
public class SRModelBase {
    required public init() {}
    
    /// 协议格式数据长度
    var dataLen: Int { 0 }
    /// 转换为协议格式数据
    func data() -> Data { Data() }
    /// 协议格式数据解析
    @discardableResult
    func parse(_ data: Data) -> Bool { false  }
}

extension SRModelBase: Equatable {
    public static func == (lhs: SRModelBase, rhs: SRModelBase) -> Bool {
        lhs.data() == rhs.data()
    }
}

public extension SRModelBase {
    var kitString: String { data().kitString }
}

public extension Array where Element == SRModelBase  {
    var kitString: String {
        return "[\(map { "\($0)" }.joined(separator: ",\n "))]"
    }
}

