//
//  SRUpdateInfo.swift
//  CTFit
//
//  Created by Mac on 2020/8/26.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation

public class SRUpdateInfo: SRModelProtocol {
    /// 文件名
    public private(set) var FileName: String?
    /// 下载路劲l
    public private(set) var FileURL: String?
    /// 版本号
    public private(set) var Version: UInt8 = 0
    /// size
    public private(set) var FileSize: UInt32 = 0
    /// 判断有效性
    public var valid: Bool {
        if FileName != nil, FileURL != nil, Version > 0, FileSize > 1024 { return true }
        return false
    }
    
    // MARK: - Initialize
    required public init() {}

}

extension SRUpdateInfo {
    /// 解析服务器返回数据
    public static func parse(_ serverJsonString: String) -> SRUpdateInfo? {
        return deserialize(from: serverJsonString)
    }
}



