//
//  SRAlarmExercise.swift
//  BandKit
//
//  Created by Mac on 2020/5/8.
//

import Foundation

/// 运动模式心率报警
public class SRAlarmExercise: SRModelBase, SRModelProtocol {
    
    /// 开关  —  0:关闭，1:心率过高报警开，2:心率过低和过高都打开
    public var feature: UInt8 = 0
    /// 过高心率
    public var heartRateHigh: UInt8 = 160
    /// 过低心率
    public var heartRateLow: UInt8 = 90
    /// 震动
    public var vibrate = SRVibrate()

    ///: - Initialize
    required public init() {}
    
    public init(feature: UInt8 = 0, heartRateHigh: UInt8 = 160, heartRateLow: UInt8 = 90) {
        self.feature = feature
        self.heartRateHigh = heartRateHigh
        self.heartRateLow = heartRateLow
    }
    
    public var highestEnable: Bool {
        get { feature != 0 }
        set {
            if !newValue  { feature = 0 }
            else if feature != 2  { feature = 1 }
        }
    }
    
    public var lowestEnable: Bool {
        get { feature == 2 }
        set {
            if newValue  { feature = 2 }
            else if feature != 0 { feature = 1 }
        }
    }

    ///: - override
    
    override var dataLen: Int { 4 }

    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putBytes([feature ,heartRateHigh, heartRateLow, vibrate.byte])
        return buffer.bufferData
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        self.feature = buffer.get()
        self.heartRateHigh = buffer.get()
        self.heartRateLow = buffer.get()
        self.vibrate.byte = buffer.get()
        return true
    }
}

extension SRAlarmExercise {

    func csvContent() -> String {
        let titleItems = ["Sport heart rate alarm,Feature", ",Heart rate high", ",Heart rate low", ",Vibration"]
        let valueItems: [String] = data().map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
