//
//  SRBlackList.swift
//  BandKit
//
//  Created by NEIL on 2020/5/9.
//

import Foundation

public enum SRAncsAppType: Int, SREnumtProtocol {
    case qq
    case wechat
    case sina
    case facebook
    case line
    case instagram
    case kakotalk
    case gmail
    
    case twitter
    case linkin
    case whatsapp
    case skype
    case sms
    case email
    
    var value: UInt16 {
        switch self {
        case .qq:       return 0x8000
        case .wechat:   return 0x4000
        case .sina:     return 0x2000
        case .facebook: return 0x1000
        case .line:     return 0x0800
        case .instagram:return 0x0400
        case .kakotalk: return 0x0200
        case .gmail:    return 0x0100
        
        case .twitter:  return 0x0080
        case .linkin:   return 0x0040
        case .whatsapp: return 0x0020
        case .skype:    return 0x0010
        case .sms:      return 0x0008
        case .email:    return 0x0004
        }
    }
}

public class SRBlackList: SRModelBase, SRModelProtocol {
    /// Field
    public var list: [SRAncsAppType] = [SRAncsAppType]()
    
    ///: - Initialize
    required public init() {}
    public init(options: [SRAncsAppType]) {
        self.list = options
    }

    ///: - override
    override var dataLen: Int { 2 }

    override func data() -> Data {
        var value: UInt16 = 0
        list.forEach { (e) in value |= e.value }
        
        let buffer = SRByteBuffer(order: .bigEndian)
        buffer.putShort(value)
        return buffer.bufferData
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data, order: .bigEndian)
        let value: UInt16 = buffer.getShort()
        let masks:[SRAncsAppType] = [.qq, .wechat, .sina, .facebook, .line, .instagram, .kakotalk, .gmail,
                                     .twitter, .linkin, .whatsapp, .skype, .sms, .email]
        list.removeAll()
        masks.forEach { (e) in if value&e.value == e.value { list.append(e)} }
        return true
    }
}

extension SRBlackList: CustomStringConvertible {
    public var description: String {
        """
        [\(list.map { String(describing: $0) }.joined(separator: ","))]
        """
    }
}

extension SRBlackList {
    
    func value() -> UInt16 {
        var value: UInt16 = 0
        list.forEach { (e) in value |= e.value }
        return value
    }

    func csvContent() -> String {
        /// String(value(), radix: 16)
        /// String(format: "0x%llX", value())
        let content = "Message push app blacklist" + "," + "\(value())" + "\n"
        return content
    }
}

