//
//  SRFeature.swift
//  BandKit
//
//  Created by Mac on 2020/5/8.
//

import Foundation

public class SRFeature: SRModelBase, SRModelProtocol {
    /// 开关: 0 关闭 、1 打开
    public var feature: UInt8 = 0
    /// 开始小时 ( 0 ~ 23 )
    public var startHour: UInt8 = 6
    /// 结束小时 ( 0 ~ 23 )
    public var endHour: UInt8 = 23

    ///: - Initialize
    required public init() {}
    public init(feature: UInt8 = 0, startHour: UInt8 = 6, endHour: UInt8 = 23) {
        self.feature = feature
        self.startHour = startHour
        self.endHour = endHour
    }
    
    ///: - internal
    
    var periodTime: String { return String(format: "%02d:00~%02d:59", min(startHour, 23), min(endHour, 23)) }

    ///: - override
    
    override var dataLen: Int { 3 }

    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putBytes([feature ,startHour, endHour])
        return buffer.bufferData
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        self.feature    = buffer.get()
        self.startHour  = buffer.get()
        self.endHour    = buffer.get()

        return true
    }
}


extension SRFeature: CustomStringConvertible {
    public var description: String {
        """
        {"feature": \(feature), "periodTime": \(periodTime)}
        """
    }
}

extension SRFeature {

    func csvContent(name: String) -> String {
        let titleItems = ["\(name),Feature", ",Start hour", ",End hour"]
        let valueItems: [String] = data().map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
