//
//  SRGoal.swift
//  BandKit
//
//  Created by Mac on 2020/5/8.
//

import Foundation

public class SRGoal: SRModelBase, SRModelProtocol {
    /// 步数
    public var step: UInt16 = 8000
    /// 卡路里 ( 大卡==千卡 )
    public var calories: UInt16 = 500
    /// 距离（100m）
    public var distance: UInt8 = 40

    ///: - Initialize
    required public init() {}
    public init(step: UInt16 = 8000, calories: UInt16 = 500, distance: UInt8 = 40) {
        self.step = step
        self.calories = calories
        self.distance = distance
    }
    
    ///: - override
    
    override var dataLen: Int { 5 }
        
    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putShort(step)
        buffer.putShort(calories)
        buffer.putByte(distance)
        return buffer.bufferData
    }
    
    
    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count==dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        step = buffer.getShort()
        calories = buffer.getShort()
        distance = buffer.get()
        return true
    }
}


extension SRGoal {
    
    func csvContent() -> String {
        let titleItems = ["Goal,Step", ",Calories", ",Distance"]
        let valueItems: [String] = [step, calories, UInt16(distance)].map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
