//
//  SRReachRing.swift
//  BandKit
//
//  Created by Mac on 2020/5/8.
//

import Foundation

public class SRReachRing: SRModelBase, SRModelProtocol {
    /// 步数
    public var step: SRVibrate = SRVibrate(type: .staccato, count: 25)
    /// 卡路里
    public var calories: SRVibrate = SRVibrate(type: .none, count: 0)
    /// 距离
    public var distance: SRVibrate = SRVibrate(type: .none, count: 0)
    
    ///: - Initialize
    required public init() {}
    public init(step: SRVibrate = SRVibrate(type: .staccato, count: 25),
                calories: SRVibrate = SRVibrate(type: .none, count: 0),
                distance: SRVibrate = SRVibrate(type: .none, count: 0)) {
        self.step = step
        self.calories = calories
        self.distance = distance
    }
    ///: - override
    
    override var dataLen: Int { 3 }

    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putBytes([step.byte ,calories.byte, distance.byte])
        return buffer.bufferData
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        self.step.byte = buffer.get()
        self.calories.byte = buffer.get()
        self.distance.byte = buffer.get()
        return true
    }
}

extension SRReachRing {

    func csvContent() -> String {
        let titleItems = ["Reach ring vibrate,Step", ",Calories", ",Distance"]
        let valueItems: [String] = data().map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
