//
//  SRRemind.swift
//  BandKit
//
//  Created by Mac on 2020/5/8.
//

import Foundation

public class SRRemind: SRModelBase, SRModelProtocol{
    /// 开关: 0 关闭 、1 打开
    public var feature: UInt8 = 0
    /// 开始小时 ( 0 ~ 23 )
    public var startHour: UInt8 = 8
    /// 结束小时 ( 0 ~ 23 )
    public var endHour: UInt8 = 18
    /// 震动
    public var vibrate = SRVibrate()

    ///: - Initialize
    required public init() {}
    public init(feature: UInt8 = 0, startHour: UInt8 = 8, endHour: UInt8 = 18, vibrate: SRVibrate = SRVibrate()) {
        self.feature = feature
        self.startHour = startHour
        self.endHour = endHour
        self.vibrate = vibrate
    }

    ///: - internal
    
    var periodTime: String { return String(format: "%02d:00~%02d:59", min(startHour, 23), min(endHour, 23)) }
    
    ///: - override
    
    override var dataLen: Int { 4 }

    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putBytes([feature ,startHour, endHour, vibrate.byte])
        return buffer.bufferData
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        self.feature    = buffer.get()
        self.startHour  = buffer.get()
        self.endHour    = buffer.get()
        self.vibrate.byte = buffer.get()
        return true
    }
}

extension SRRemind {

    func csvContent(name: String) -> String {
        let titleItems = ["\(name),Feature", ",Start hour", ",End hour", ",Vibration",]
        let valueItems: [String] = data().map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
