//
//  SRRemindInterval.swift
//  BandKit
//
//  Created by NEIL on 2020/5/10.
//

import Foundation

public class SRRemindInterval: SRModelBase, SRModelProtocol {
    /// 开关: 0 关闭 、1 打开、 2（久坐提醒开启，并开启午休勿打扰（12~14））
    public var feature: UInt8 = 0
    /// 开始小时 ( 0 ~ 23 )
    public var startHour: UInt8 = 8
    /// 结束小时 ( 0 ~ 23 )
    public var endHour: UInt8 = 20
    /// 震动 abyx 时无此参数
    public var vibrate: SRVibrate = SRVibrate()
    /// 间隔时间 ( 分钟 )，默认 60
    public var interval: UInt8 = 60

    // MARK: - Initialize
    required public init() {}
    public init(feature: UInt8 = 0, startHour: UInt8 = 6, endHour: UInt8 = 23, vibrate: SRVibrate = SRVibrate(), interval: UInt8 = 60) {
        self.feature = feature
        self.startHour = startHour
        self.endHour = endHour
        self.vibrate = vibrate
        self.interval = interval
    }
    
    ///: - Internal
    var periodTime: String { return String(format: "%02d:00~%02d:59", min(startHour, 23), min(endHour, 23)) }
    
    ///: - override
    
    override var dataLen: Int { 5 }

    override func data() -> Data {
        let buffer = SRByteBuffer()
        buffer.putBytes([feature ,startHour, endHour, vibrate.byte, interval])
        return buffer.bufferData
    }

    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false}
        let buffer = SRByteBuffer(with: data)
        self.feature    = buffer.get()
        self.startHour  = buffer.get()
        self.endHour    = buffer.get()
        self.vibrate.byte = buffer.get()
        self.interval   = buffer.get()

        return true
    }
}

extension SRRemindInterval {
    func csvContent(name: String, noVibrate: Bool = false) -> String {
        var titleItems = ["\(name),Feature", ",Start hour", ",End hour", ",Vibration" , ",Intervl minutes"]
        var valueItems: [String] = data().map{ String($0) }
        if noVibrate {
            titleItems.remove(at: 3)
            valueItems.remove(at: 3)
        }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
