//
//  SRUser.swift
//  BandKit
//
//  Created by Mac on 2020/5/8.
//

import Foundation

public class SRUser: SRModelBase, SRModelProtocol {
    /// 年龄
    public var age: UInt8 = 25
    /// 体重（kg）
    public var weight: UInt8 = 65
    /// 步幅（cm）—  走
    public var strideWalk: UInt8 = 65
    /// 步幅（cm）—  跑
    public var strideRun: UInt8 = 80
    
    
    ///: - Initialize
    required public init() {}

    ///: - Initialize
    override var dataLen: Int { 3 }
    
    override func data() -> Data {
        Data([weight ,strideWalk, strideRun])
    }
    
    @discardableResult
    override func parse(_ data: Data) -> Bool {
        guard data.count == dataLen else { return false }
        let buffer = SRByteBuffer(with: data)
        self.weight     = buffer.get()
        self.strideWalk = buffer.get()
        self.strideRun  = buffer.get()
        return true
    }
}

extension SRUser {
    
    private func datae() -> Data {
        Data([age, weight ,strideWalk, strideRun])
    }
    
    public static func == (lhs: SRUser, rhs: SRUser) -> Bool {
        lhs.datae() == rhs.datae()
    }
}

extension SRUser {
    func csvContent(name: String, drink: SRDrinkInfo? = nil) -> String {
        var titleItems = ["User,Name", ",Age", ",Weight", ",Walk stride", ",Run stride"]
        var valueItems: [String] =  [name]+datae().map{ String($0) }
        if let hasDrink = drink {
            titleItems.insert(",Gender", at: 1)
            titleItems.insert(",Height", at: 3)
            titleItems += [",Reference sbp", ",Reference dbp"]
            valueItems.insert("\(hasDrink.gender.value)", at: 1)
            valueItems.insert("\(hasDrink.height)", at: 3)
            valueItems += [hasDrink.sbpReference, hasDrink.dbpReference].map{String($0)}
        }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
