//
//  SRWeatherItem.swift
//  BandKit
//
//  Created by Mac on 2020/7/6.
//

import Foundation
import HandyJSON

func valueRange(_ val: Int, _ rangeMin: Int, _ rangeMax: Int) -> Int {
    return min(max(val, rangeMin), rangeMax)
}

// MARK: - 小时项

public class SRWeatherHourItem: SRModelProtocol {
    /// 天气类型
    public private(set) var type: SRWeatherType = .unknown
    /// 温度 摄氏度（-50 ~ 50）
    public private(set) var temperature: Int8 = 100
    /// 湿度
    public private(set) var humidity: UInt8 = 0
    /// 风向
    public private(set) var windDirection: UInt8 = 0
    /// 风速 m/s
    public private(set) var windSpeed: UInt8 = 0
    /// 大气压强
    public private(set) var airPressure: UInt16 = 0
    /// 紫外线
    public private(set) var sunuv: UInt8 = 0

    // MARK: - Initialize
    required public init() { }
    
    static func parse(_ array: [Int]) -> SRWeatherHourItem? {
        guard array.count >= 7 else { return nil }
        let item = SRWeatherHourItem()
        item.type = SRWeatherType.parse(array[0])
        item.temperature = Int8(valueRange(array[1], -50, 50))
        item.airPressure = UInt16(array[2])
        item.humidity = UInt8(array[3])
        item.sunuv = UInt8(array[4])
        item.windSpeed = UInt8(array[5])
        item.windDirection = direction(with: array[6])
        return item
    }
    
    /// 角度 转 方向 （东、东南 ... ） 8个方向
    private static func direction(with deg: Int) -> UInt8 {
        let direction = ((10*deg+225)%3600)/450
        return UInt8(direction)
    }
}


// MARK: - 每天项

public class SRWeatherDayItem: SRModelProtocol {
    /// 天气类型
    public private(set) var type: SRWeatherType = .unknown
    /// 最底温度 摄氏度（-50 ~ 50）
    public private(set) var temperatureMin: Int8 = -50
    /// 最高温度 摄氏度（-50 ~ 50）
    public private(set) var temperatureMax: Int8 = 50
    /// 湿度
    public private(set) var humidity: UInt8 = 50
    /// 日出 （分钟）
    public private(set) var sunrise: UInt16 = 390 // 06: 30
    /// 日落 （分钟）
    public private(set) var sunset: UInt16 = 1110 // 18: 30

    // MARK: - Initialize
    required public init() { }
    
    static func parse(_ array: [Int]) -> SRWeatherDayItem? {
        guard array.count >= 6 else { return nil }
        let item = SRWeatherDayItem()
        item.temperatureMax = Int8(valueRange(array[0], -50, 50))
        item.temperatureMin = Int8(valueRange(array[1], -50, 50))
        item.type = SRWeatherType.parse(array[2])
        item.humidity = UInt8(array[3])
        item.sunrise = UInt16(array[4])
        item.sunset = UInt16(array[5])
        return item
    }
}

