//
//  CmdQueue.swift
//  BandKit
//
//  Created by Mac on 2020/4/29.
//

import Foundation
import RxBluetoothKit

private let kCmdOpQueue = DispatchQueue(label: "com.jpaxh.bandkit.CmdQueue")

func cmdSyncAction(_ block: @escaping () -> Void) {
    kCmdOpQueue.sync {
        block()
    }
}

func cmdSyncAction(dalay: TimeInterval, _ block: @escaping () -> Void) {
    kCmdOpQueue.asyncAfter(deadline: .now() + dalay, execute: {
        block()
    })
}

func cmdAsyncAction(_ block: @escaping () -> Void) {
    kCmdOpQueue.async {
        block()
    }
}

class CmdQueue {
    
    typealias CmdArrayType = [CmdHolder]
    
    private var cmdArray = CmdArrayType()

    
    var count: Int { return cmdArray.count; }
    
    // MARK: - 队列操作
    
    /// 从队头取出
    func pop() -> CmdHolder? {
        if let e = cmdArray.first {
            cmdArray.removeFirst()
            return e
        }
        return nil
    }
    
    /// 取出指定元素
    func pop(_ cmd: CmdHolder) {
        guard let index = firstIndex(cmd) else { return }
        cmdArray.remove(at: index)
    }
    
    /// 取出指定定标识的元素
    func pop(_ cmdType: SRCommandType) -> CmdHolder? {
        guard let item = first(cmdType) else { return nil }
        pop(item)
        return item;
    }
    
    /// 清除队列
    func clear() {
        cmdArray.forEach { (cmd) in cmd.onCancel() }
        cmdArray.removeAll()
    }
    
    /// 直接加入到队尾
    /// - Parameter cmd: 新命令元素
    func push(_ cmd: CmdHolder) {
        cmdArray.append(cmd)
    }
    
    /// 直接插入到队头
    /// - Parameter cmd: 新命令元素
    func insertHeader(_ cmd:CmdHolder) {
        cmdArray.insert(cmd, at: 0)
    }
    
    /// 更新加入到队列
    /// - Parameter cmd: 新命令元素
    func updatePush(_ cmd:CmdHolder) {
        if cmd.type.cmd >= 0x80 {
            cmdArray.forEach { (e) in if e===cmd { e.onUpdate() } }
            cmdArray.removeAll { (e) -> Bool in return e===cmd }
        } else {
            cmdArray.forEach { (e) in if e==cmd { e.onUpdate() } }
            cmdArray.removeAll { (e) -> Bool in return e==cmd }
        }
        cmdArray.append(cmd)
    }
    
    /// 更新插入到队头
    /// - Parameter cmd: 新命令元素
    func updateInsertHeader(_ cmd:CmdHolder) {
        if cmd.type.cmd >= 0x80 {
            cmdArray.forEach { (e) in if e===cmd { e.onUpdate() } }
            cmdArray.removeAll { (e) -> Bool in return e===cmd }
        } else {
            cmdArray.forEach { (e) in if e==cmd { e.onUpdate() } }
            cmdArray.removeAll { (e) -> Bool in return e==cmd }
        }
        cmdArray.forEach { (e) in if e==cmd { e.onUpdate() } }
        cmdArray.removeAll { (e) -> Bool in return e==cmd }
        cmdArray.insert(cmd, at: 0)
    }
    
    // MARK: - 查找
    
    func firstIndex(_ cmd: CmdHolder) -> Int? {
        return cmdArray.firstIndex(of: cmd)
    }
    
    func firstIndex(_ cmdType: SRCommandType) -> Int? {
        return cmdArray.firstIndex(where: { (e) -> Bool in return e.type == cmdType })
    }
    
    func first(_ cmd: CmdHolder) -> CmdHolder? {
        return cmdArray.first(where: { (e) -> Bool in return e == cmd })
    }
    
    func first(_ cmdType:SRCommandType) -> CmdHolder? {
        return cmdArray.first(where: { (e) -> Bool in return e.type == cmdType })
    }
}
