//
//  CmdReponse.swift
//  BandKit
//
//  Created by Mac on 2020/4/30.
//

import Foundation

class CmdReponse {

    init(_ cmd: UInt8, _ ext: UInt8, _ byte1: UInt8, error: Error? = nil) {
        self.cmd = cmd
        self.ext = ext
        self.byte1 = byte1
        self.error = error
        self.describe = SRCommandType.name(cmd, ext, byte1)
    }
    
    init(_ type: SRCommandType, error: Error? = nil) {
        self.cmd = type.cmd
        self.ext = type.ext
        self.byte1 = type.byte1
        self.error = error
        self.describe =  type.name

    }
    
    let cmd: UInt8
    let ext: UInt8
    let byte1: UInt8?
    var error: Error?
    var packets: [Data] = []
    /// 命令类型
    var type: SRCommandType? { SRCommandType.parse(cmd, ext, byte1 ?? 0x00)  }
    /// 命令类型描述
    var describe: String
    /// 不由 CmdHolder 接收的通知数据或则超时数据
    var notify: Bool = true
    

    var code: SRReponseCode = .success
    var data: Data? = nil
    var model: SRModelBase?


    func onParse() {
        if let hasType = type,
           let model = hasType.model,
           let hasData = data,
           model.parse(hasData) { self.model = model }
        else {
            model = nil
        }
    }
    
    func print() {
        if let _ = error {
            if let _ = error as? SRRequestError { return }
            BandLog.w(loggerText)
        } else if notify {
            if case .devRecord(.total, .t0) = type  { return }
            BandLog.w(loggerText)
        } else {
            BandLog.d(loggerText)
        }
    }
}

// MARK: - Logger 日记

extension CmdReponse {
    
    private var textReceived: String { "Received: \(describe)" } // 发送命令应答
    private var textNotifyed: String { "Notifyed: \(describe)" } // 手表主动推送数据，或则应答超时
    
    /// 收到的数据包
    private var textPacket: String {
        guard packets.count<3 else { return "Packets: [1...\(packets.count)]" }
        return "Packets: \(packets.logDescription)"
    }
    /// 数据包是否可解析的数据模型：1. 读取数据时可以解析  2. 写入数据只有成功和错误代码
    private var textParsed: String? {
        guard let hasModel = model else { return nil }
        return "Parsed: \(hasModel)"
    }
    /// 数据错误：1. 读取数据 格式出错  2 写入数据对应错误码
    private var textError: String? {
        guard let hasError = error else { return nil }
        return "Error: \(hasError)"
    }
    ///
    private var textReponse: String {
        guard notify else { return textReceived }
        return textNotifyed
    }
    
    private var loggerText: String {
        var textLogger: String = "\(textReponse)"
        textLogger += "\n\(textPacket)"
        if let text = textParsed { textLogger += "\n\(text)"}
        if let text = textError  { textLogger += "\n\(text)"}
        return textLogger
    }
}
