//
//  SRBindPeripheral.swift
//  BandKit
//
//  Created by NEIL on 2020/5/29.
//

import Foundation

public class SRBindPeripheral {
    
    public private(set) var uuid: String
    
    public private(set) var name: String

    init(with uuid: String, name: String) {
        self.uuid = uuid
        self.name = name
    }
    
    public func updateName(_ newName: String) {
        self.name = newName
        save()
    }
    
    public func save() {
        UserDefaults.standard.setValue(dictionary, forKey: SRBindPeripheral.userDefaultsKey)
        UserDefaults.standard.synchronize()
    }
    
    public func remove() {
        UserDefaults.standard.removeObject(forKey: SRBindPeripheral.userDefaultsKey)
        UserDefaults.standard.synchronize()
    }
        
    private var dictionary: [String: Any] { return ["name": name, "uuid": uuid] }
}

extension SRBindPeripheral: CustomStringConvertible {
    public var description: String {
        return """
        \(dictionary)
        """
    }
}

public extension SRBindPeripheral {
    
    private static let userDefaultsKey = "BindPeripheral.UserDefaults.Key"

    static var hasBinded: SRBindPeripheral? {
        guard let dictionary = UserDefaults.standard.object(forKey: userDefaultsKey) as? [String: Any],
            let uuid = dictionary["uuid"] as? String,
            let name = dictionary["name"] as? String else { return nil}
        return SRBindPeripheral(with: uuid, name: name)
    }
}


