//
//  NESQLiteManager.swift
//  CTFit
//
//  Created by Mac on 2020/6/18.
//  Copyright © 2020 shirajo. All rights reserved.
//

import GRDB

/// 数据库连接
public class NESQLiteManager {
    
    private static let documentPath: String? = {
        return NSSearchPathForDirectoriesInDomains(.documentDirectory, .userDomainMask, true).first;
    }()
    
    /// 判断是否存在数据库文件
    private static func exitDBFile(_ path: String?) -> Bool {
        guard let hasPath = path,
              FileManager.default.fileExists(atPath: hasPath) else { return false }
        return true
    }
    
    /// 数据库配置
    private static let configuration: Configuration = {
        /// 配置
        var configuration = Configuration()
        /// 设置超时
        configuration.busyMode = Database.BusyMode.timeout(5.0)
        /// 试图访问锁着的数据
        /// configuration.busyMode = Database.BusyMode.immediateError
        return configuration
    }()
    
    /// 创建 DatabaseQueue
    private static func createDbQueue(_ path: String?) -> DatabaseQueue? {
        guard let hasPath = path else { return nil }
        do {
            let db = try DatabaseQueue(path: hasPath, configuration: configuration)
            db.releaseMemory()
            return db
        } catch {
            print("\(error)")
        }
        return nil
    }
    
    private static func deleteFile(_ path: String?) {
        guard let hasPath = path, exitDBFile(hasPath) else { return }
        do {
            try FileManager.default.removeItem(atPath: hasPath)
        } catch {
        }
    }
    
    static func remove() {
        guard let hasPath = dbPath, exitDBFile(hasPath) else { return }
        do {
            try FileManager.default.removeItem(atPath: hasPath)
        } catch {
        }
    }
}

/// : - BHSportsDataZ7.db
extension NESQLiteManager {
    
    /// 数据库路径
    private static let databaseName = "BHSportsDataZ7.db"
    private static let dbPath: String? = {
        guard let docPath = documentPath else { return nil }
        let filePath: String = docPath.appending("/\(databaseName)")
        return filePath
    }()
    
    private static var _dbQueue: DatabaseQueue? = nil
    
    /// 数据库 用于多线程事务处理
    public static var dbQueue: DatabaseQueue? {
        guard let hasDBQueue = _dbQueue, exitDBFile(dbPath) else {
            _dbQueue = createDbQueue(dbPath)
            return _dbQueue
        }
        return hasDBQueue
    }
}

/// : - SDatabase.db
extension NESQLiteManager {
    
    private static let databaseName_s = "SDatabase.db"
    private static let dbPath_s: String? = {
        guard let docPath = documentPath else { return nil }
        let filePath: String = docPath.appending("/\(databaseName_s)")
        return filePath
    } ()
    
    private static var _dbQueue_s: DatabaseQueue? = nil
    public static var dbQueue_s: DatabaseQueue? {
        guard let hasDBQueue = _dbQueue_s, exitDBFile(dbPath_s) else {
            _dbQueue_s = createDbQueue(dbPath_s)
            return _dbQueue_s
        }
        return hasDBQueue
    }

}
