//
//  SRLifeCycle.swift
//  CTFit
//
//  Created by Mac on 2020/7/14.
//  Copyright © 2020 shirajo. All rights reserved.
//

import Foundation
import UIKit
import RxSwift

public enum NEAppNotifyType {
    case didEnterBackground
    case willEnterForeground
    case didFinishLaunching
    case didBecomeActive
    case willResignActive
    case didReceiveMemoryWarning
    case willTerminate
    case significantTimeChange
    case orientationDidChange
}

public class NEAppNotifyUtils {
    
    private let subject = PublishSubject<NEAppNotifyType>()
    
    init() { addObserver() }
    
    deinit { removeObserver() }
    
    private func addObserver() {
        NotificationCenter.default.addObserver(self, selector: #selector(didEnterBackground), name: UIApplication.didEnterBackgroundNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(willEnterForeground), name: UIApplication.willEnterForegroundNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(didFinishLaunching), name: UIApplication.didFinishLaunchingNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(didBecomeActive), name: UIApplication.didBecomeActiveNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(willResignActive), name: UIApplication.willResignActiveNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(didReceiveMemoryWarning), name: UIApplication.didReceiveMemoryWarningNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(willTerminate), name: UIApplication.willTerminateNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(significantTimeChange), name: UIApplication.significantTimeChangeNotification, object: nil)
        NotificationCenter.default.addObserver(self, selector: #selector(orientationDidChange), name: UIApplication.didChangeStatusBarOrientationNotification, object: nil)

        
    }
    
    private func removeObserver() {
        NotificationCenter.default.removeObserver(self, name: UIApplication.didFinishLaunchingNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.willEnterForegroundNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.didFinishLaunchingNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.didBecomeActiveNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.willResignActiveNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.didReceiveMemoryWarningNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.willTerminateNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.significantTimeChangeNotification, object: nil)
        NotificationCenter.default.removeObserver(self, name: UIApplication.didChangeStatusBarOrientationNotification, object: nil)

    }
}

extension NEAppNotifyUtils {
    
    private static let shared = NEAppNotifyUtils()
    
    @objc private func didEnterBackground() {
        NELog.i("didEnterBackground")
        subject.onNext(.didEnterBackground)
    }
    @objc private func willEnterForeground() {
        NELog.i("willEnterForeground")
        subject.onNext(.willEnterForeground)
    }
    
    @objc private func didFinishLaunching() {
        NELog.i("didFinishLaunching")
        subject.onNext(.didFinishLaunching)
    }
    @objc private func didBecomeActive() {
        NELog.i("didBecomeActive")
        subject.onNext(.didBecomeActive)
    }
    @objc private func willResignActive() {
        NELog.i("willResignActive")
        subject.onNext(.willResignActive)
    }
    
    @objc private func didReceiveMemoryWarning() {
        NELog.i("didReceiveMemoryWarning")
        subject.onNext(.didReceiveMemoryWarning)
    }
    @objc private func willTerminate() {
        NELog.i("willTerminate")
        subject.onNext(.willTerminate)
    }
    @objc private func significantTimeChange() {
        NELog.i("significantTimeChange")
        subject.onNext(.significantTimeChange)
    }

    @objc private func orientationDidChange() {
        NELog.i("orientationDidChange")
        subject.onNext(.orientationDidChange)
    }
}


extension NEAppNotifyUtils {
    open class var observable: Observable<NEAppNotifyType> {
        return shared.subject.asObservable()
    }
}
