//
//  NEModelProtocol.swift
//  NEUtils
//
//  Created by Mac on 2021/11/9.
//

import Foundation
import HandyJSON

// MARK: - Copyable
public protocol NECopyable: Codable {
    func copy() -> Self
}
public extension NECopyable {
    func copy() -> Self {
        let encoder = JSONEncoder()
        guard let data = try? encoder.encode(self) else { fatalError("encode失败") }
        let decoder = JSONDecoder()
        guard let target = try? decoder.decode(Self.self, from: data) else { fatalError("decode失败") }
        return target
    }
}

// MARK: - EnumtProtocol
public protocol NEEnumtProtocol: NECopyable, HandyJSONEnum {}


// MARK: - ModelProtocol
public protocol NEModelProtocol: NECopyable, HandyJSON, CustomStringConvertible {}
public extension NEModelProtocol {
    var json: [String: Any] { toJSON() ?? [String: Any]() }
    var jsonString: String { toJSONString() ?? "{ Nil }" }
    var jsonStringPrettyPrint: String { toJSONString(prettyPrint: true) ?? "{ Nil }" }
    var description: String { jsonString }
}
