//
//  NEWeatherCode.swift
//  BandKit
//
//  Created by Mac on 2020/7/6.
//

import Foundation
import HandyJSON

public enum NEWeatherCode: Int, NEEnumtProtocol  {
    /// MARK: Group 2xx ThunderStorm    11
    case THUNDERSTORM_RAIN_LIGHT = 200
    case THUNDERSTORM_RAIN = 201
    case THUNDERSTORM_RAIN_HEAVY = 202
    case THUNDERSTORM = 210 // 雷雨
    case THUNDERSTORM_LIGHT = 211
    case THUNDERSTORM_HEAVY = 212
    case THUNDERSTORM_RAGGED = 221
    case THUNDERSTORM_DRIZZLE_LIGHT = 230
    case THUNDERSTORM_DRIZZLE = 231 // 毛毛雨
    case THUNDERSTORM_DRIZZLE_HEAVY = 232
    case THUNDERSTORM_WITH_HAIL = 233  // -

    
    /// MARK: Group 3xx Drizzle   3
    case DRIZZLE_LIGHT = 300
    case DRIZZLE = 301
    case DRIZZLE_HEAVY = 302
    case DRIZZLE_RAIN_LIGHT = 310
    case DRIZZLE_RIAN = 311
    case DRIZZLE_RAIN_HEAVY = 312
    case DRIZZLE_RAIN_SHOWER = 313
    case DRIZZLE_RAIN_SHOWER_HEAVY = 314
    case DRIZZLE_SHOWER = 321


    /// MARK: Group 5xx Rain
    case RAIN_LIGHT = 500 // 小雨 3
    case RAIN_MODERATE = 501 // 中雨 4
    case RAIN_HEAVY_INTENSITY = 502 // 大雨  5
    case RAIN_VERY_HEAVY = 503 // 暴雨
    case RAIN_EXTREME = 504 // 强降雨
    case RAIN_FREEZING = 511 // 冻雨
    case RAIN_LIGHT_SHOWER = 520   //  3
    case RAIN_SHOWER = 521 // 阵雨  6
    case RAIN_HEAVY_SHOWER = 522 // 强阵雨
    case RAIN_RAGGED_SHOWER = 531
    
    /// MARK: Group 6xx Snow   7
    case SNOW_LIGHT = 600 // 小雪
    case SNOW = 601 // 雪
    case SNOW_HEAVY = 602 // 大雪
    case MIX_SNOW = 610 // 夹雪 -
    case SLEET = 611 // 雨夹雪
    case SLEET_SHOWER = 612 // 小阵雨夹雪
    case SHOWER_SLEET = 613 // 阵雨夹雪
    case SNOW_LIGHT_RAIN = 615 // 小雨夹雪
    case SNOW_RAIN = 616 // 雨雪天气
    case SNOW_SHOWER_LIGHT = 620 // 阵雪
    case SNOW_SHOWER = 621 // 阵雪
    case SNOW_SHOWER_HEAVY = 622 // 阵雪
    case FLURRIES = 623 // 大风加雪 -

    
    /// MARK: Group 7xx Atmosphere  8
    case MIST_I = 700 // 薄雾 8 -
    case MIST = 701 // 薄雾 8
    case SMOKE = 711 // 雾 8
    case HAZE = 721 // 霾 8
    case DUST_WHIRLS = 731 // 尘卷风 9
    case FOG = 741 // 雾 8
    case SAND = 751 // 扬沙 9
    case DUST = 761 // 浮尘 9
    case VOLCANIC_ASH = 762 // 火山灰 8
    case SQUALLS = 771 // 飓风    9
    case TORNADO = 781 // 龙卷风 9
    
    
    /// MARK: Group 800 Clear
    case CLEAR_SKY = 800 //  晴   0
    
    /// MARK: Group 80x Clouds
    case CLOUDS_FEWER = 801 // 疏云  1
    case CLOUDS_SCATTERED = 802 // 少云
    case CLOUDS_BROKEN = 803 // 多云  2
    case CLOUDS_OVERCAST = 804 // 阴天
}

extension NEWeatherCode: Equatable, Comparable {
    public static func == (lhs: NEWeatherCode, rhs: NEWeatherCode) -> Bool { (lhs.rawValue == rhs.rawValue) }
    public static func <  (lhs: NEWeatherCode, rhs: NEWeatherCode) -> Bool { (lhs.rawValue <  rhs.rawValue) }
    public static func >  (lhs: NEWeatherCode, rhs: NEWeatherCode) -> Bool { (lhs.rawValue >  rhs.rawValue) }
    public static func <= (lhs: NEWeatherCode, rhs: NEWeatherCode) -> Bool { (lhs.rawValue <= rhs.rawValue) }
    public static func >= (lhs: NEWeatherCode, rhs: NEWeatherCode) -> Bool { (lhs.rawValue >= rhs.rawValue) }
}

public enum NEWeatherType: Int, NEEnumtProtocol  {
    case fineDay = 0           // 晴天
    case cloudy = 1            // 多云
    case overCast = 2          // 阴天
    case lightRain = 3         // 小雨
    case moderateRain = 4      // 中雨
    case heavyRain = 5         // 大雨
    case shower = 6            // 阵雨
    case snow = 7              // 下雪
    case haze = 8              // 雾霾
    case sandStorm = 9         // 沙尘暴
    case cloudyToFine = 10     // 多云转晴
    case thunderStorm = 11     // 雷雨
    case unknown = 12           // 未知天气
    
    static func parse(_ code: Int) -> NEWeatherType {
        /// 雷雨
        if code >= NEWeatherCode.THUNDERSTORM_RAIN_LIGHT.rawValue, code <= NEWeatherCode.THUNDERSTORM_WITH_HAIL.rawValue { return .thunderStorm }
        /// 小雨
        if code >= NEWeatherCode.DRIZZLE_LIGHT.rawValue, code <= NEWeatherCode.DRIZZLE_SHOWER.rawValue {  return .lightRain }
        /// 雨
        if code >= NEWeatherCode.RAIN_LIGHT.rawValue, code <= NEWeatherCode.RAIN_RAGGED_SHOWER.rawValue {
            /// 小雨
            if (code == NEWeatherCode.RAIN_LIGHT.rawValue ||
                code == NEWeatherCode.RAIN_LIGHT_SHOWER.rawValue) { return .lightRain }
            /// 中雨
            if code == NEWeatherCode.RAIN_MODERATE.rawValue { return .moderateRain }
            /// 大雨
            if (code == NEWeatherCode.RAIN_HEAVY_INTENSITY.rawValue ||
                code == NEWeatherCode.RAIN_VERY_HEAVY.rawValue ||
                code == NEWeatherCode.RAIN_EXTREME.rawValue ||
                code == NEWeatherCode.RAIN_FREEZING.rawValue) { return .heavyRain }
            /// 阵雨
            if (code == NEWeatherCode.RAIN_SHOWER.rawValue ||
                code == NEWeatherCode.RAIN_HEAVY_SHOWER.rawValue ||
                code == NEWeatherCode.RAIN_RAGGED_SHOWER.rawValue) { return .shower }
            /// 中雨
            return .moderateRain
        }
        
        /// 雪
        if code >= NEWeatherCode.SNOW_LIGHT.rawValue, code <= NEWeatherCode.FLURRIES.rawValue { return .snow }
        
        /// 沙尘暴+雾霾
        if code >= NEWeatherCode.MIST_I.rawValue, code <= NEWeatherCode.TORNADO.rawValue {
            /// 沙尘暴
            if (code == NEWeatherCode.DUST_WHIRLS.rawValue ||
                code == NEWeatherCode.SAND.rawValue ||
                code == NEWeatherCode.DUST.rawValue ||
                code == NEWeatherCode.SQUALLS.rawValue ||
                code == NEWeatherCode.TORNADO.rawValue) { return .sandStorm }
            /// 雾霾
            return .haze
        }
        
        /// 晴+多云+阴天
        /// 晴
        if code == NEWeatherCode.CLEAR_SKY.rawValue { return .fineDay }
        /// 多云转晴
        if code == NEWeatherCode.CLOUDS_FEWER.rawValue ||
            code == NEWeatherCode.CLOUDS_SCATTERED.rawValue { return .cloudyToFine }
        /// 多云
        if code == NEWeatherCode.CLOUDS_BROKEN.rawValue ||
            code == NEWeatherCode.CLOUDS_OVERCAST.rawValue { return .cloudy }
        
        /// 未知
        return .unknown
    }
}
