//
//  TDAsyncLabel.m
//  TDAppMonitor
//
//  Created by Beck.Wang on 2018/4/3.
//  Copyright © 2018年 TDW.CN. All rights reserved.
//  异步绘制标签栏

#import "TDAsyncLabel.h"
#import "TDDispatchAsync.h"
#import <CoreText/CoreText.h>

@implementation TDAsyncLabel

- (void)setText: (NSString *)text {
    dispatch_async(dispatch_get_main_queue(), ^{
        NSAttributedString *attributedText = [[NSAttributedString alloc] initWithString: text attributes: @{ NSFontAttributeName: self.font, NSForegroundColorAttributeName: self.textColor }];
        NSTextAlignment alignment = self.textAlignment;
        CGSize size = self.frame.size;
        UIFont *font = self.font;
        TDDispatchQueueAsyncBlockInBackground(^{
            [self displayAttributedText: attributedText alignment: alignment size: size font: font];
        });
    });
}

- (void)setAttributedText: (NSAttributedString *)attributedText {
    
    dispatch_async(dispatch_get_main_queue(), ^{
        NSTextAlignment alignment = self.textAlignment;
        CGSize size = self.frame.size;
        UIFont *font = self.font;
        TDDispatchQueueAsyncBlockInBackground(^{
            [self displayAttributedText: attributedText alignment: alignment size: size font: font];
        });
    });

}

- (void)displayAttributedText: (NSAttributedString *)attributedText alignment: (NSTextAlignment)alignment size: (CGSize)_size font: (UIFont *)font {
    if (attributedText == nil) {
        attributedText = [NSMutableAttributedString new];
    } else if ([attributedText isMemberOfClass: [NSAttributedString class]]) {
        attributedText = attributedText.mutableCopy;
    }
    
    NSMutableParagraphStyle * style = [NSMutableParagraphStyle new];
    [((NSMutableAttributedString *)attributedText) addAttributes: @{ NSParagraphStyleAttributeName: style } range: NSMakeRange(0, attributedText.length)];
    
    CGSize size = _size;
    size.height += 10;
    UIGraphicsBeginImageContextWithOptions(size, NO, 0);
    CGContextRef context = UIGraphicsGetCurrentContext();
    if (context != NULL) {
        CGContextSetTextMatrix(context, CGAffineTransformIdentity);
        CGContextTranslateCTM(context, 0, size.height);
        CGContextScaleCTM(context, 1, -1);
        
        CGSize textSize = [attributedText.string boundingRectWithSize: size options: NSStringDrawingUsesLineFragmentOrigin attributes: @{ NSFontAttributeName: font } context: nil].size;
        textSize.width = ceil(textSize.width);
        textSize.height = ceil(textSize.height);
        
        CGMutablePathRef path = CGPathCreateMutable();
        CGPathAddRect(path, NULL, CGRectMake((size.width - textSize.width) / 2, 5, textSize.width, textSize.height));
        CTFramesetterRef frameSetter = CTFramesetterCreateWithAttributedString((CFAttributedStringRef)attributedText);
        CTFrameRef frame = CTFramesetterCreateFrame(frameSetter, CFRangeMake(0, attributedText.length), path, NULL);
        CTFrameDraw(frame, context);
        
        UIImage * contents = UIGraphicsGetImageFromCurrentImageContext();
        UIGraphicsEndImageContext();
        CFRelease(frameSetter);
        CFRelease(frame);
        CFRelease(path);
        dispatch_async(dispatch_get_main_queue(), ^{
            self.layer.contents = (id)contents.CGImage;
        });
    }
}


@end
