### Timer

*注**:由于任何其他对象“中继器”类都受标准内存管理规则的约束。因此，一旦您创建了计时器实例，您需要将它保留在某个地方，以避免在启动命令之后过早地释放它。

#### 创建单触发计时器

下面的代码创建一个计时器，它在5秒后触发一次。

```swift
self.timer = Repeater.once(after: .seconds(5)) { timer in
  // do something    
}
```

#### 创建循环有限定时器

下面的代码创建一个周期性计时器:它将每10分钟触发5次，然后停止。

```swift
self.timer = Repeater.every(.minutes(10), count: 5) { timer  in
  // do something        
}
```

#### 创建循环无限计时器

The following code create a recurrent timer which fires every hour until it is manually stopped .

```swift
self.timer = Repeater.every(.hours(1)) { timer in
  // do something
}
```

#### 管理一个计时器

您可以创建一个新的timer实例，并根据需要通过调用' start() '函数来启动它.

```swift
self.timer = Repeater(interval: .seconds(5), mode: .infinite) { _ in
  // do something        
}
timer.start()
```

其他功能:

* `start()`: 启动暂停或新创建的计时器
* `pause()`: 暂停正在运行的计时器
* `reset(_ interval: Interval, restart: Bool)`: 重置一个正在运行的计时器，更改间隔，如果设置，则重新启动.
* `fire()`: 从外部源手动触发计时器的事件

属性:

* `.id`: 计时器的唯一标识符
* `.mode`: 定义计时器的类型 (`infinite`,`finite`,`once`)
* `.remainingIterations`: 在有限模式下，它包含完成之前剩余的迭代次数。

#### Adding/Removing Observers

默认情况下，一个新的计时器有一个由init函数指定的观察者。但是，您可以使用“observe()”函数创建额外的观察者。这个调用的结果是一个令牌标识符，您可以使用它在第二次中删除观察者。
回调中收到的定时器实例是弱的。

```swift
let token = timer.observe { _ in
  // a new observer is called        
}
timer.start()
```

你可以使用令牌来移除观察者:

```swift 
timer.remove(token)
```

#### 观察状态变化

Each timer can be in one of the following states, you can observe via `.state` property:

* `.paused`: timer is in idle (never started yet) or paused
* `.running`: timer is currently active and running
* `.executing`: registered observers are being executed
* `.finished`: timer lifecycle is finished (it's valid for a finite/once state timer)

You can listen for state change by assigning a function callback for `.onStateChanged` property.

```swift
timer.onStateChanged = { (timer,newState) in
    // your own code
}
```
<a name="debouncer"/>

### Debouncer

Since 0.5 Repeater introduced `Debouncer` class.
Debouncer会延迟一个函数调用，每次它被调用时都会延迟前一个调用，直到延迟时间结束.

debounce函数是一个非常有用的工具，可以帮助控制请求。
但是，由于每个时间段只允许一个请求，所以debounce不会立即触发，而是在触发请求之前等待指定的时间段。
如果在时间段结束之前有另一个请求，那么我们将重新开始计数。这对于调用经常被调用的函数非常有用，并且只需要在所有更改完成后运行一次.

```swift
let debouncer = Debouncer(.seconds(10))
debouncer.callback = {
    // your code here
}

// 调用debouncer在延迟时间之后启动回调
// 多个调用将忽略旧的调用并覆盖触发时间.
debouncer.call()
```

(Make sure to check out the Unit Tests for further code samples.)

<a name="throttler"/>

### Throttler

Since 0.5 Repeater introduced `Throttler` class.

Throttling用Throttling逻辑包装代码块，保证一个动作在每个指定的间隔中不会被调用超过一次。当延迟过去时，只执行最后一个分派的代码块.

```swift
let throttler = Throttler(time: .milliseconds(500), {
  // your code here
})

// Call throttler. Defined block will never be called more than once each specified interval.
throttler.call()
```

## Requirements

Repeat is compatible with Swift 4.x.
All Apple platforms are supported:

* iOS 8.0+
* macOS 10.10+
* watchOS 2.0+
* tvOS 9.0+
