import RxSwift

extension ObservableType {
    /// 将a和b观察到的所有事件吸收为结果观察对象.
    ///
    /// - parameter a:第一个可观察对象
    /// - parameter b: 第二个可观察对象
    /// - returns: 新的“可观察对象”从a和b的可观察对象中发出所有的事件。
    /// 如果错误或完成是接收到的任何一个'被观察者‘，它立即传播到结果'被观察者‘
    static func absorb(_ a: Observable<Element>, _ b: Observable<Element>) -> Observable<Element> {
        return .create { observer in
            let disposable = CompositeDisposable()
            let innerObserver: AnyObserver<Element> = AnyObserver { event in
                observer.on(event)
                if event.isStopEvent {
                    disposable.dispose()
                }
            }
            _ = disposable.insert(a.subscribe(innerObserver))
            if !disposable.isDisposed {
                _ = disposable.insert(b.subscribe(innerObserver))
            }

            return disposable
        }
    }
}
