import Foundation
import CoreBluetooth

protocol UUIDIdentifiable {
    var uuid: CBUUID { get }
}

/// 根据提供的UUID列表筛选项列表。项目必须符合UUIDIdentifiable
/// 仅返回UUID与提供的UUID列表中的项匹配的项。
/// 如果requredAll为真，则每个UUID应该在项列表中至少有一个匹配的项。
/// 否则结果为nill.
/// - uuids: UUID列表或nil
/// - items: 要过滤的项目
/// - requireAll: 如果该参数为真且uuid不是项的子集，则方法将返回nil
/// - Returns: 过滤后的项目列表
func filterUUIDItems<T: UUIDIdentifiable>(uuids: [CBUUID]?, items: [T], requireAll: Bool) -> [T]? {
    guard let uuids = uuids, !uuids.isEmpty else { return items }

    let itemsUUIDs = items.map { $0.uuid }
    let uuidsSet = Set(uuids)
    guard !requireAll || uuidsSet.isSubset(of: Set(itemsUUIDs)) else { return nil }
    return items.filter { uuidsSet.contains($0.uuid) }
}
