import Foundation
import CoreBluetooth
import RxSwift

///'CoreBluetooth CentralManager' 回调上的包装器
class CBCentralManagerDelegateWrapper: NSObject, CBCentralManagerDelegate {

    let didUpdateState = PublishSubject<BluetoothState>()
    let willRestoreState = ReplaySubject<[String: Any]>.create(bufferSize: 1)
    let didDiscoverPeripheral = PublishSubject<(CBPeripheral, [String: Any], NSNumber)>()
    let didConnectPeripheral = PublishSubject<CBPeripheral>()
    let didFailToConnectPeripheral = PublishSubject<(CBPeripheral, Error?)>()
    let didDisconnectPeripheral = PublishSubject<(CBPeripheral, Error?)>()

    func centralManagerDidUpdateState(_ central: CBCentralManager) {
        guard let bleState = BluetoothState(rawValue: central.state.rawValue) else { return }
        BleLog.i("\(central.logDescription) didUpdateState(state: \(bleState.logDescription))")
        didUpdateState.onNext(bleState)
    }

    func centralManager(_ central: CBCentralManager, willRestoreState dict: [String: Any]) {
        BleLog.i("\(central.logDescription) willRestoreState(restoredState: \(dict))")
        willRestoreState.onNext(dict)
    }

    func centralManager(_ central: CBCentralManager,
                        didDiscover peripheral: CBPeripheral,
                        advertisementData: [String: Any],
                        rssi: NSNumber) {
        BleLog.i("""
            \(central.logDescription) didDiscover(peripheral: \(peripheral.logDescription),
            advertisementData: \(advertisementData)
            rssi: \(rssi))
            """)
        didDiscoverPeripheral.onNext((peripheral, advertisementData, rssi))
    }

    func centralManager(_ central: CBCentralManager, didConnect peripheral: CBPeripheral) {
        BleLog.i("""
            \(central.logDescription) didConnect(to: \(peripheral.logDescription))
            """)
        didConnectPeripheral.onNext(peripheral)
    }

    func centralManager(_ central: CBCentralManager, didFailToConnect peripheral: CBPeripheral, error: Error?) {
        BleLog.i("""
            \(central.logDescription) didFailToConnect(to: \(peripheral.logDescription),
            error: \(String(describing: error)))
            """)
        didFailToConnectPeripheral.onNext((peripheral, error))
    }

    func centralManager(_ central: CBCentralManager, didDisconnectPeripheral peripheral: CBPeripheral, error: Error?) {
        BleLog.i("""
            \(central.logDescription) didDisconnect(from: \(peripheral.logDescription),
            error: \(String(describing: error)))
            """)
        didDisconnectPeripheral.onNext((peripheral, error))
    }
}
