import Foundation
import CoreBluetooth

/// 表示被扫描的外设的实例——包含它的advertisment数据、rssi和peripheral本身
/// 为了执行进一步的操作，可以使用“peripheral”实例变量。保持连接
public class ScannedPeripheral{

    /// `Peripheral` 实例, 这允许执行进一步的蓝牙操作.
    public let peripheral: Peripheral

    /// 扫描peripheral的广告数据
    public let advertisementData: AdvertisementData

    /// RSSI value.
    public let rssi: NSNumber

    public init(peripheral: Peripheral, advertisementData: AdvertisementData, rssi: NSNumber) {
        self.peripheral = peripheral
        self.advertisementData = advertisementData
        self.rssi = rssi
    }
    
    public convenience init(peripheral: Peripheral) {
        self.init(peripheral: peripheral, advertisementData: AdvertisementData(advertisementData: [String : Any]()), rssi: NSNumber(value: 0))
    }
}
