//
//  ZJTableViewSection.swift
//  NewRetail
//
//  Created by Javen on 2018/2/8.
//  Copyright © 2018年 . All rights reserved.
//

import UIKit

public typealias ZJTableViewSectionBlock = (ZJTableViewSection) -> Void

open class ZJTableViewSection: NSObject {
    public weak var tableViewManager: ZJTableViewManager!
    public var items = [ZJTableViewItem]()
    public var headerHeight: CGFloat!
    public var footerHeight: CGFloat!
    public var headerView: UIView?
    public var footerView: UIView?
    public var headerTitle: String?
    public var footerTitle: String?
    
    var headerWillDisplayHandler: ZJTableViewSectionBlock?
    public func setHeaderWillDisplayHandler(_ block: ZJTableViewSectionBlock?) {
        headerWillDisplayHandler = block
    }

    var headerDidEndDisplayHandler: ZJTableViewSectionBlock?
    public func setHeaderDidEndDisplayHandler(_ block: ZJTableViewSectionBlock?) {
        headerDidEndDisplayHandler = block
    }
    
    var footerWillDisplayHandler: ZJTableViewSectionBlock?
    public func setFooterWillDisplayHandler(_ block: ZJTableViewSectionBlock?) {
        footerWillDisplayHandler = block
    }

    var footerDidEndDisplayHandler: ZJTableViewSectionBlock?
    public func setFooterDidEndDisplayHandler(_ block: ZJTableViewSectionBlock?) {
        footerDidEndDisplayHandler = block
    }

    public var index: Int? {
        return tableViewManager.sections.zj_indexOf(self)
    }

    public override init() {
        super.init()
        items = []
        headerHeight = CGFloat.leastNormalMagnitude
        footerHeight = CGFloat.leastNormalMagnitude
    }

    public convenience init(headerHeight: CGFloat, color: UIColor) {
        let headerView = UIView(frame: CGRect(x: 0, y: 0, width: UIScreen.main.bounds.width, height: headerHeight))
        headerView.backgroundColor = color
        self.init(headerView: headerView, footerView: nil)
    }
    
    public convenience init(footerHeight: CGFloat, color: UIColor) {
        let fotterView = UIView(frame: CGRect(x: 0, y: 0, width: UIScreen.main.bounds.width, height: footerHeight))
        fotterView.backgroundColor = color
        self.init(headerView: nil, footerView: fotterView)
    }
    
    public convenience init(headerHeight: CGFloat, footerHeight: CGFloat, color: UIColor) {
        let headerView = UIView(frame: CGRect(x: 0, y: 0, width: UIScreen.main.bounds.width, height: headerHeight))
        headerView.backgroundColor = color
        let fotterView = UIView(frame: CGRect(x: 0, y: 0, width: UIScreen.main.bounds.width, height: footerHeight))
        fotterView.backgroundColor = color
        self.init(headerView: headerView, footerView: fotterView)
    }

    public convenience init(headerTitle: String?, footerTitle: String?) {
        self.init()
        self.headerTitle = headerTitle
        self.footerTitle = footerTitle
    }

    public convenience init(headerTitle: String?) {
        self.init(headerTitle: headerTitle, footerTitle: nil)
    }

    public convenience init(footerTitle: String?) {
        self.init(headerTitle: nil, footerTitle: footerTitle)
    }

    public convenience init(headerView: UIView!) {
        self.init(headerView: headerView, footerView: nil)
    }

    public convenience init(footerView: UIView?) {
        self.init(headerView: nil, footerView: footerView)
    }

    public convenience init(headerView: UIView?, footerView: UIView?) {
        self.init()
        if let header = headerView {
            self.headerView = header
            headerHeight = header.frame.size.height
        }

        if let footer = footerView {
            self.footerView = footer
            footerHeight = footer.frame.size.height
        }
    }

    public func add(item: ZJTableViewItem) {
        item.section = self
        item.tableViewManager = tableViewManager
        items.append(item)
    }

    public func remove(item: ZJTableViewItem) {
        guard let index = items.zj_indexOf(item) else { return }
        items.remove(at: index)
    }

    public func removeAllItems() {
        items.removeAll()
    }

    public func replaceItemsFrom(array: [ZJTableViewItem]!) {
        removeAllItems()
        items = items + array
    }

    public func insert(_ item: ZJTableViewItem, afterItem: ZJTableViewItem, animate: UITableView.RowAnimation = .automatic) {
        guard let index = items.zj_indexOf(afterItem) else { return }
                
        tableViewManager.tableView.beginUpdates()
        item.section = self
        item.tableViewManager = tableViewManager
        items.insert(item, at: index + 1)
        if let idxp = item.indexPath { tableViewManager.tableView.insertRows(at: [idxp], with: animate) }
        tableViewManager.tableView.endUpdates()
    }

    public func insert(_ items: [ZJTableViewItem], afterItem: ZJTableViewItem, animate: UITableView.RowAnimation = .automatic) {
        guard let afterItemIdxp = afterItem.indexPath else { return }

        tableViewManager.tableView.beginUpdates()
        let newFirstRow = afterItemIdxp.row + 1
        self.items.insert(contentsOf: items, at: newFirstRow)
        var arrNewIndexPath = [IndexPath]()
        for i in 0 ..< items.count {
            items[i].section = self
            items[i].tableViewManager = tableViewManager
            arrNewIndexPath.append(IndexPath(item: newFirstRow + i, section: afterItemIdxp.section))
        }
        tableViewManager.tableView.insertRows(at: arrNewIndexPath, with: animate)
        tableViewManager.tableView.endUpdates()
    }

    public func delete(_ itemsToDelete: [ZJTableViewItem], animate: UITableView.RowAnimation = .automatic) {
        guard itemsToDelete.count > 0 else { return }
        tableViewManager.tableView.beginUpdates()
        
        var arrNewIndexPath = [IndexPath]()
        for item in itemsToDelete {
            if let idxp = item.indexPath { arrNewIndexPath.append(idxp) }
        }
        for item in itemsToDelete {
            remove(item: item)
        }
        
        tableViewManager.tableView.deleteRows(at: arrNewIndexPath, with: animate)
        tableViewManager.tableView.endUpdates()
    }

    public func reload(_ animation: UITableView.RowAnimation = .automatic) {
        guard let index = tableViewManager.sections.zj_indexOf(self) else { return }
        tableViewManager.tableView.reloadSections(IndexSet(integer: index), with: animation)
    }
}
