//
//  CEProductK6.h
//  CE_BleSDK
//
//  Created by cxq on 2017/1/3.
//  Copyright © 2017年 celink. All rights reserved.
//

#import "CEProduct.h"

#import "CE_SyncPairOKCmd.h"
#import "CE_SystemPairCmd.h"
#import "CE_SensorCmd.h"
#import "CE_AppExitCmd.h"

#import "CE_RequestSystemPairStatusCmd.h"
#import "CE_RequestOTAStatusCmd.h"
#import "CE_RequestUserInfo.h"
#import "CE_RequestDevInfoCmd.h"
#import "CE_RequestBatteryCmd.h"
#import "CE_RequestAlarmInfoCmd.h"
#import "CE_RequestAllInfoCmd.h"
#import "CE_RequestSettingButtonFunCmd.h"
#import "CE_RequestLongSitCmd.h"
#import "CE_RequestDisturbCmd.h"
#import "CE_RequestGoalCmd.h"
#import "CE_RequestBloodPresureCmd.h"
#import "CE_SyncUserInfoCmd.h"
#import "CE_SyncSettingK6Cmd.h"
#import "CE_SyncAlarmK6Cmd.h"
#import "CE_SyncTimeCmd.h"
#import "CE_UnitSettingCmd.h"
#import "CE_SyncWeatherCmd.h"
#import "CE_SyncHybridCmd.h"
#import "CE_SendPhotoCmd.h"
#import "CE_SyncGoalCmd.h"
#import "CE_SyncWatchMenuCmd.h"
#import "CE_SendOtaDataCmd.h"
#import "CE_SyncMusicInfoCmd.h"
#import "CE_SyncGpsArgumentCmd.h"
#import "CE_SyncLongSitRemindCmd.h"
#import "CE_SyncPhoneControlCmd.h"
#import "CE_SyncDisturbCmd.h"
#import "CE_SyncResetCmd.h"

#import "YD_SyncSMSAlarmCmd.h"
#import "YD_SyncCallAlarmCmd.h"
#import "YD_SyncFinishGoalCmd.h"
#import "YD_SyncDrinkAlarmCmd.h"
#import "YD_SyncUpBrightCmd.h"
#import "YD_SyncAutoHeartCmd.h"
#import "YD_SyncFindDevCmd.h"
#import "YD_SyncLanguageCmd.h"

#import "CE_SyncHeartO2Cmd.h"
#import "CE_SyncECGCmd.h"
#import "CE_SyncBloodPressureCmd.h"

/**  蓝牙状态改变，非关闭。都会自动发送一次自动重连（有UUID 才能连上） */

/** 接收数据通知 */
extern NSString *const CEProductK6ReceiveDataNoticeKey;

@interface CEProductK6 : CEProduct

/** 产品ID号，区分不同产品*/
@property (nonatomic, assign) NSInteger pid;

+ (instancetype)shareInstance;

/** 发送各种命令,并加入到队列(收到应答才发队列中的下个命令) */
- (void)sendCmdToDevice:(CE_Cmd *)cmd complete:(void(^)(NSError* error))handler;

/** 清空cmd队列 */
- (void)cleanCmdQueue;

@end








