//
//  CE_SyncLongSitRemindCmd.h
//  CE_BleSDK
//
//  Created by LiJie on 2017/3/2.
//  Copyright © 2017年 celink. All rights reserved.
//

#import "CE_Cmd.h"

/**
  APP通过发送SET_LONGSIT_REMIND命令到设备侧以设置久坐提醒时间
 */
@interface CE_SyncLongSitRemindCmd : CE_Cmd

/**
 提醒开关 0：关闭提醒，1：打开提醒
 */
@property (nonatomic,assign) uint8_t flag;

/**
  重复的时间，每一位中使用0或1表示改天是否开启重复
  bit0->monday, bit1->tuesday ... bit6->sunday
 */
@property (nonatomic,assign) uint8_t week_repeat;

/**
  开始时间 小时
 */
@property (nonatomic, assign) uint8_t startTimeHour;

/**
 开始时间 分钟
 */
@property (nonatomic, assign) uint8_t startTimemin;

/**
 结束时间 小时
 */
@property (nonatomic, assign) uint8_t endTimeHour;

/**
 结束时间 分钟
 */
@property (nonatomic, assign) uint8_t endTimeMin;

/**
 中午免打扰开关 0-关闭， 1-开启
 */
@property (nonatomic, assign) Byte noon_onoff;

@end
