//
//  CE_SyncWeatherCmd.h
//  K2SDKDemo
//
//  Created by cxq on 2016/12/28.
//  Copyright © 2016年 celink. All rights reserved.
//

#import "CE_Cmd.h"

/**
 同步天气信息
 */
@interface CE_WeatherItem : NSObject

/**
 天气类型，0：晴天；1：阴天；2：下雨；3：其它
 */
@property (nonatomic,assign) uint8_t weather;

/**
 最低温度值
 */
@property (nonatomic,assign) uint8_t low_temperature; //最低温度值

/**
 最高温度值
 */
@property (nonatomic,assign) uint8_t high_temperature;

/**
 pm 数值
 */
@property (nonatomic,assign) uint16_t PM;

- (NSData *)itemData;

@end

@interface CE_SyncWeatherCmd : CE_Cmd

/**
 天气同步的时间
 */
@property (nonatomic, assign) int32_t time;

/**
 今天天气信息
 */
@property (nonatomic, strong) CE_WeatherItem *todyWeather;

/**
 明天天气信息
 */
@property (nonatomic, strong) CE_WeatherItem *tomorrowWeather;

/**
 后天天气信息
 */
@property (nonatomic, strong) CE_WeatherItem *dayAfterTomorrowWeather;

@end
