//
//  FuncType.h
//  CE_BleSDK
//
//  Created by cxq on 2017/1/14.
//  Copyright © 2017年 celink. All rights reserved.
//
#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, K6_DataFuncType){
    DATA_TYPE_NULL = 0,
    
    /* 1.device to app cmdType (1-100) */
    DEV_TO_APP_START_TYPE = 1,
    DATA_TYPE_DEVINFO,               //0x02
    DATA_TYPE_BATTERY_INFO,          //0x03
    DATA_TYPE_REAL_SPORT,            //0x04
    DATA_TYPE_HISTORY_SPORT,         //0x05
    DATA_TYPE_SLEEP,                 //0x06
    DATA_TYPE_REAL_HEART,            //0x07
    DATA_TYPE_HISTORY_HEART,         //0x08
    DATA_TYPE_DEV_SYNC,              //0x09
    DATA_TYPE_MIX_SPORT,             //0x0a
    DATA_TYPE_FIND_PHONE_OR_DEVICE,  //0x0b
    DATA_TYPE_BLE_PAIR_STATUS,       //0x0c
    DATA_TYPE_USER_CHANGE,           //0x0d
    DATA_TYPE_MUSIC_CONTROL,         //0x0e
    DATA_TYPE_CALL_CONTROL_TO_APP,   //0x0f
    DATA_TYPE_GSENSOR_TEST,          //0x10
    DATA_TYPE_EXERCISE_HEART,        //0x11
    DATA_TYPE_REAL_BP,               //0x12
    DATA_TYPE_REAL_ECG,              //0x13
    DATA_TYPE_REAL_O2,               //0x14
    DEV_TO_APP_END_TYPE = 100,       //0x64
    
    /* 2.app to device cmdType (101-200) */
    APP_TO_DEV_START_TYPE = 101,
    DATA_TYPE_USERINFO,              //0x66  102
    DATA_TYPE_LANGUAGE_SETTING,      //0x67  103
    DATA_TYPE_TIME,                  //0x68  104
    DATA_TYPE_WEATHER,               //0x69  105
    DATA_TYPE_ALARM,                 //0x6a  106
    DATA_TYPE_MESSAGE_NOTICE,        //0x6b  107
    DATA_TYPE_APP_CLOSE,             //0x6c  108
    DATA_TYPE_SET_DATA_SWITCH,       //0x6d  109
    DATA_TYPE_APP_SYNC,              //0x6e  110
    DATA_TYPE_SET_TARGET,            //0x6f  111
    DATA_TYPE_OPEN_BLE_PAIR,         //0x70  112
    DATA_TYPE_MUSIC_CONTENT,         //0x71  113
    DATA_TYPE_SITTING_REMIND,        //0x72  114
    DATA_TYPE_FORGET_DISTURB,        //0x73  115
    DATA_TYPE_PHOTOGRAPH_ONOFF,      //0x74  116
    DATA_TYPE_CALL_CONTROL_TO_DEV,   //0x75  117
    DATA_TYPE_RESET,                 //0x76  118
    DATA_TYPE_SHUTDOWN,              //0x77  119
    DATA_TYPE_PAIR_FINISH,           //0x78  120
    DATA_TYPE_UNIT_SETTING,          //0x79  121
    DATA_TYPE_CALL_ALARM,            //0x7a  122
    DATA_TYPE_MESSAGE_ALARM,         //0x7b  123
    DATA_TYPE_MESSAGE_SWITCH,        //0x7c  124
    DATA_TYPE_TARGET_ALARM,          //0x7d  125
    DATA_TYPE_DRINK_ALARM,           //0x7e  126
    DATA_TYPE_HAND_RISE_SWITCH,      //0x7f  127
    DATA_TYPE_HEART_AUTO_SWITCH,     //0x80  128
    DATA_TYPE_WATCH_SETTING,         //0x81  129
    DATA_TYPE_APP_SPORT,
    
    APP_TO_DEV_END_TYPE = 200,
    
    /* 3.No use (201-255) */
    DATA_TYPE_OTA_STATUS,
    DATA_TYPE_OTA_DATA,
    DATA_TYPE_TEST_DEBUG
};

//1.3 命令类型：
typedef enum
{
    K6_CMD_TYPE_NULL = 0,
    K6_CMD_TYPE_SEND,		//发送命令
    K6_CMD_TYPE_SEND_NO_ACK,//无应答的发送命令
    K6_CMD_TYPE_REQUEST,	//请求命令
    K6_CMD_TYPE_ACK,		//应答命令
}K6_CMD_TYPE;

typedef NS_ENUM(NSInteger,CheckReceiveType) {
    
    ReceiveFirstPackage,                //接收新数据的第一个包
    ReceiveFirstPackageAndEndPackage,   //接收新数据的第一个包也是最后一个包
    ReceiveEndPackage,                  //接收新数据最后一个包
    ReceiveNeedMore,                    //接收到数据，但不是最后一个，需要接收更多包
    ReceiveSerialNumberError,           //接收数据的流水号不对
    ReceivePackageHeaderError,          //接收数据的包头不对
    
    receive_unknown_more//未知错误
};

typedef enum
{
    MUSIC_CMD_NULL = 0,
    MUSIC_CMD_PLAY,				//播放音乐
    MUSIC_CMD_PAUSE,			//暂停音乐
    MUSIC_CMD_STOP,				//关闭音乐
    MUSIC_CMD_BACKWARD,         //上一首
    MUSIC_CMD_FORWARD,          //下一首
    MUSIC_CMD_CONTENT,			//获取歌曲内容
}MUSIC_CMD_TYPE;


/**  OTA 升级状态 */
typedef  enum
{
    OTA_NONE = 0,			//未升级
    OTA_RUNING,				//正在升级过程中
    OTA_FINISH_SUCCESS,		//升级成功
    OTA_FINISH_WRONG,		//升级错误
    OTA_IMG_SIZE_ERROR,		//镜像文件的总长度错误
    OTA_IMG_CRC16_ERROR,	//镜像文件的CRC16值错误
    OTA_ITEM_HEAD_LEN_ERROR, 	//单个条目头的长度值错误，
    OTA_ITEM_HEAD_LEN_ERROR_ALL = OTA_ITEM_HEAD_LEN_ERROR + 10,
    OTA_ITEM_MEDIA_ERROR, 		//单个条目的存储介质错误
    OTA_ITEM_MEDIA_ERROR_ALL = OTA_ITEM_MEDIA_ERROR + 10,
    OTA_ITEM_SIZE_ERROR, 		//单个条目的文件长度错误
    OTA_ITEM_SIZE_ERROR_ALL = OTA_ITEM_SIZE_ERROR + 10,
    OTA_ITEM_CRC16_ERROR, 		//单个条目文件的CRC16错误，
    OTA_ITEM_CRC16_ERROR_ALL = OTA_ITEM_CRC16_ERROR + 10,
}OTA_STATUS_TYPE;

/**  OTA 文件类型 */
typedef	enum
{
    FILE_TYPE_NULL = 0,
    FILE_TYPE_CUSTOMER,
    FILE_TYPE_HARDWARE,
    FILE_TYPE_CODE,
    FILE_TYPE_PIC,
    FILE_TYPE_FONT,
    FILE_TYPE_DATA,
}OTA_FILE_TYPE;

/**  OTA 数据存储介质类型 */
typedef enum
{
    MEDIA_MCU_FLASH = 0,		//内部flash
    MEDIA_SPI_FLASH			//外部 spi flash
}OTA_FILE_MEDIA_TYPE;


/**  电话控制，暂时不做处理 */
typedef enum
{
    CALL_CMD_NULL = 0,
    CALL_CMD_ANSWER_CALL,		//接听电话
    CALL_CMD_HANGUP_CALL,		//挂断电话
    CALL_CMD_SOUND_OFF,         //静音
}CALL_CMD_TYPE;


typedef NS_ENUM(NSInteger,ParseType) {
    
    ParseAckDataSuccess,
    ParseAckDataCrc16Error,
    ParseAckDataError,
    
    ParseDataSuccess,
    ParseDataCrc16Error,
    ParseSerialNumberError,
    
    parse_unknown_more
};

typedef NS_ENUM(NSInteger,CE_ErrorCode) {
    Error_sendFailed = -2000,
    Error_overTime,
    Error_bleClosed,
    Error_deviceDisconnect,
    Error_bleExceptional
};

/**  混杂数据 的运动类型 */
typedef enum {
    MIX_SPORT_NULL = 0,
    
    MIX_SPORT_BREATHE,          //呼吸
    MIX_SPORT_CYCLING,          //骑车或室外骑车
    MIX_SPORT_CYCLING_INDOOR,   //室内骑车
    MIX_SPORT_RUNNING_MACHINE,  //跑步机或室内跑步
    MIX_SPORT_RUN,              //跑步或室外跑步
    MIX_SPORT_SWIM,             //游泳
    MIX_SPORT_WALK,             //走路
    MIX_SPORT_WEIGHT,           //举重
    MIX_SPORT_YOGA,             //瑜咖
    MIX_SPORT_BADMINTON,        //羽毛球
    MIX_SPORT_BASKETBALL,       //篮球
    MIX_SPORT_SKIP,             //跳绳
    MIX_SPORT_FREE_EXERCISE,    //自由锻炼
    MIX_SPORT_FOOTBALL,         //足球
    MIX_SPORT_CLIMBING,         //爬山
    MIX_SPORT_PINGPONG          //乒乓球
}MIX_SPORT_TYPE;


