
import Foundation
import CoreBluetooth
import RxBluetoothKit

let YFLog = Logging(module: "YFKit", std: .verbose, file: .verbose)

// MARK: - Loggable extension

protocol Loggable {
    var logDescription: String { get }
}

extension Data: Loggable {
    public var logDescription: String {
        return map { String(format: "%02x", $0) }.joined()
    }
}

extension Array where Element: Loggable {
    var logDescription: String {
        return "[\(map { $0.logDescription }.joined(separator: ", "))]"
    }
}
