//
//  YFFirmware.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON

/// 固件
public class YFFirmware: YFModelBase {
    public private(set) var code_id: Int = 6
    public private(set) var customer_id: Int = 3
    public private(set) var font_id: Int = 0
    public private(set) var hardware_id: Int = 3
    public private(set) var items: Int = 11
    public private(set) var picture_id: Int = 2
}

extension YFFirmware {
    func csvContent() -> String {
        let data = [code_id, customer_id, font_id, hardware_id, items, picture_id]
        let titleItems = ["Firmware Id,Code", ",Customer", ",Font", ",Hardware", ",Items", ",Picture"]
        let valueItems: [String] = data.map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
