//
//  YFClockInfo.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 单位（公英制）
public class YFClockItem: YFModelBase {
    /// 标签
    public var name: String = ""
    /// 开关状态
    public var status: UInt8 = 0
    /// 重复日期 0x07F
    public var repeatDay: UInt8 = 0
    /// 小时
    public var hour: UInt8 = 0
    /// 分钟
    public var min: UInt8 = 0
    
    /// 类型（未使用）
    public var alarmType: Int = 0
    
    var cmd: CE_AlarmItem {
        let cmd = CE_AlarmItem()
        cmd.name = name
        cmd.status = status
        cmd.repeatDay = repeatDay
        cmd.hour = hour
        cmd.min = min
        return cmd
    }
}

/// 闹钟
public class YFClockInfo: YFModelBase {

    public var alarm_infos: [YFClockItem] = []
    
    var cmd: CE_SyncAlarmK6Cmd {
        let cmd = CE_SyncAlarmK6Cmd()
        cmd.alarmItems = alarm_infos.map({ $0.cmd })
        return cmd
    }
}

/// 新连接设备是否读取过数据
extension YFClockInfo {
    private static let readedKey = "YFClockInfoReadedKey"
    public static var readed: Bool {
        get {
            UserDefaults.standard.bool(forKey: readedKey)
        }
        set {
            UserDefaults.standard.set(newValue, forKey: readedKey)
            UserDefaults.standard.synchronize()
        }
    }
}
