//
//  YFGoalInfo.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 目标信息
public class YFGoalInfo: YFModelBase {
    /// 步数
    public var step: UInt32 = 10000
    /// 卡路里 （kCal）
    public var calorie: UInt32 = 500
    /// 距离 （m）
    public var distance: UInt32 = 6000
    /// 睡眠时间 （min）
    public var sleep: UInt16 = 480
    /// 运动时间 （min）
    public var sprotTime: UInt16 = 2
    
    var cmd: CE_SyncGoalCmd {
        let cmd = CE_SyncGoalCmd()
        cmd.step = step
        cmd.distance = distance
        cmd.calories = calorie
        cmd.sleep = sleep
        cmd.sportTime = sprotTime
        return cmd
    }
}

extension YFGoalInfo {
    func csvContent() -> String {
        let data = [step, calorie, distance, UInt32(sleep), UInt32(sprotTime)]
        let titleItems = ["Goal info,Step", ",Calories", ",Distance", ",Sleep time", ",Sport time"]
        let valueItems: [String] = data.map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
