//
//  YFUserInfo.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 用户信息
public class YFUserInfo: YFModelBase {
    /// 姓名
    public var name: String = "Name"
    /// 头像
    public var portraitPath: String = ""
    
    /// ID
    public var userId: UInt32 = 9527
    /// 性别
    public var sex: YFGenderType = .male
    /// 年龄
    public var age: UInt8 = 18
    /// 身高 （cm）
    public var userHeight: UInt8 = 175
    /// 体重 （kg）
    public var userWeight: UInt8 = 65
    /// 管用手
    public var lrHand: YFHandType = .right
    
    
    var cmd: CE_SyncUserInfoCmd {
        let cmd = CE_SyncUserInfoCmd()
        cmd.userId = userId
        cmd.sex = sex.rawValue
        cmd.age = age
        cmd.height = userHeight
        cmd.weight = userWeight
        cmd.lrHand = lrHand.rawValue
        return cmd
    }
    
    func update(forDevice model: YFUserInfo) {
        userId = model.userId
        sex = model.sex
        age = model.age
        userHeight = model.userHeight
        userWeight = model.userWeight
        lrHand = model.lrHand
    }
}

extension YFUserInfo {
    func csvContent(nickname: String) -> String {
        let data = [sex.rawValue, age, userHeight, userWeight, lrHand.rawValue]
        let titleItems = ["User,Name", ",Sex", ",Age", ",Height", ",Weight", ",Hand"]
        let valueItems: [String] = [nickname]+data.map{ String($0) }
        var content = ""
        for i in 0..<titleItems.count {
            content += titleItems[i] + "," + valueItems[i] + "\n"
        }
        return content
    }
}
