//
//  YFDisturb.swift
//  YFitKit
//
//  Created by Mac on 2021/4/13.
//

import Foundation
import HandyJSON
import YFitSDK

/// 免打扰
public class YFDisturb: YFModelBase {
    /// 开关转态
    public var switch_flag: YFCmdSwitchType = .off
    /// 数量
    public var count: Int = 0
    /// 免打扰时间段
    public var disturbs: [YFDisturbTimeItem] = []

    var cmd: CE_SyncDisturbCmd {
        let cmd = CE_SyncDisturbCmd()
        cmd.switch_flag = switch_flag.rawValue
        cmd.disturbItems = disturbs.map({ $0.cmd })
        return cmd
    }
}

/// 免打扰时间项
public class YFDisturbTimeItem: YFModelBase {
    /// 开始小时
    public var startHour: UInt8 = 7
    /// 开始分钟
    public var startMin: UInt8 = 0
    /// 结束小时
    public var endHour: UInt8 = 23
    /// 结束分钟
    public var endMin: UInt8 = 0
    
    var cmd: CE_DisturbItem {
        let cmd = CE_DisturbItem()
        cmd.start_time_hour = startHour
        cmd.start_time_min = startMin
        cmd.end_time_hour = endHour
        cmd.end_time_min = endMin
        return cmd
    }
}
